package com.bcxin.ars.dto.page.task;

import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.model.task.ComContract;
import com.bcxin.ars.model.task.ComContractStation;
import com.bcxin.ars.serializer.LongJsonDeserializer;
import com.bcxin.ars.serializer.LongJsonSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * @author linqinglin
 * @date 2019/10/13 0013 9:33
 */
@Data
public class ComContractSearchDto extends SearchDto<ComContract> {

    /**
     * 主键 企业合同ID
     */
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long comContractId;

    /** 是否逻辑删除 */
    private String isDelete;

    /** 合同类型 */
    private String contractType;

    /** 合同状态 */
    private String contractStatus;

    /** 合同名称 */
    private String contractName;

    /** 企业档案编号 */
    private String comFileNo;

    /** 企业所在方 */
    private String comParty;

    /** 甲方名称 */
    private String firstPartyName;

    /** 甲方联系电话 */
    private String firstPartyTel;

    /** 乙方名称 */
    private String secondPartyName;

    /** 乙方联系电话 */
    private String secondPartyTel;

    /** 生效开始日期 */
    private Date effectStartDate;

    /** 生效终止日期 */
    private Date effectEndDate;

    /** 合同期限 */
    private String contractPeriod;

    /** 协议签订日期 */
    private Date agreementSignDate;

    /** 合同文件url */
    private String contractUrl;
    /***
     * 甲方联系地址
     */
    private String firstPartyAddress;
    /***
     * 乙方联系地址
     */
    private String secondPartyAddress;

    /** 备注 */
    private String remark;

    /***
     * 合同驻勤点
     */
    private String taskStationArrs;
    /***
     * 合同驻勤信息
     */
    private List<ComContractStation> comContractStationList;

    /** 企业ID */
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long comId;

    /** 人员ID */
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long perId;
    /**
     * 驻勤点
     */
    private String taskName;

    private Long taskId;
    /**
     * 驻勤点个数
     */
    private Long taskNum;
    /**
     * 是否关联驻勤点
     */
    private String isHaveTask;
    protected Integer pageNumber;//页数
    protected Integer pageSize;//每页显示几条

    @Override
    public Integer getStart() {
        return (this.pageNumber == null ? 0:(this.pageNumber-1)) * (this.pageSize == null ? 0:this.pageSize);
    }
}
