package com.bcxin.ars.dto.page;

import com.bcxin.ars.dto.SearchDto;
import lombok.Data;

/**
 * 保安员分页搜索dto
 * @author linqinglin
 * @date 2019/05/14 0014 13:46
 */
@Data
public class PersonPageSearchDto extends SearchDto<PersonDto> {

    /**
     * 部门名称
     */
    private  String departName;

    /**
     * 公司名称
     */
    private String companyName;

    /**
     * 公司id
     */
    private String companyId;

    /**
     * 姓名
     */
    private String realName;

    /**
     * 身份证号
     */
    private String idNumber;

    /**
     * 手机号
     */
    private String phone;

    /*
        资格证持证状态
     */
    private String certificateState;

    /**
     * 实名认证
     */
    private String identityAuthState;

    /**
     * 在职状态
     */
    private String incumbencyStatus;

    /**
     * 所属机构类型
     */
    private String institutionType;

    /**
     * 企业录入时间开始
     */
    private String createStartDate;

    /**
     * 企业录入时间结束
     */
    private String createEndDate;

    /**
     * 入职时间开始
     */
    private String startDate;

    /**
     * 入职时间结束
     */
    private String endDate;
    /**
     * 离职查询开始时间
     */
    private String leaveStartDate;
    /**
     * 离职查询结束时间
     */
    private String leaveEndDate;
    /**
     * 分管机构id
     */
    private Long orgId;

    /**
     * 超时未持证天数 开始
     */
    private Long startDay;

    /**
     * 超时未持证天数 结束
     */
    private Long endDay;

    /**
     * 人员类型，1内勤人员，2普通保安员，3武装押运人员
     */
    private String personType;

    /**
     * 激活状态 0 未激活 1已激活
     */
    private String init;

    /**
     * 任务id
     */
    private Long comTaskId;

    /**
     * 临保任务id
     */
    private Long comTempTaskId;

    /**
     * 任务名称
     */
    private Long taskName;


    /***
     * 数据来源
     */
    private String dataType;


    /***
     * 保安员证编码
     */
    private String zgcredential;
    /***
     * 是否显示旧数据
     */
    private String oldData;


    /***
     * 性别
     */
    private String gender;


    /***
     * 籍贯
     */
    private String nativePlace;

    /***
     * 是否有驻勤任务
     */
    private String comTaskFlag;

    /***
     * 民族
     */
    private String nation;

    /***
     * 是否只查询新系统
     */
    private String newSystem;


    /***
     * 人员Id
     */
    private Long personId;

    protected Integer pageNumber;//页数
    protected Integer pageSize;//每页显示几条

    @Override
    public Integer getStart() {
        return (this.pageNumber == null ? 0:(this.pageNumber-1)) * (this.pageSize == null ? 0:this.pageSize);
    }
}
