package com.bcxin.ars.dto.page;

import com.bcxin.ars.serializer.LongJsonDeserializer;
import com.bcxin.ars.serializer.LongJsonSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;

import java.io.Serializable;

/**
 * @author linqinglin
 * @date 2020/06/11 0011 16:55
 */
@Data
public class PerconUnRegDto implements Serializable {

    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long id;

    /*
        姓名
     */
    private String realName;

    /**
     * 身份证号
     */
    private String idNumber;

    /**
     * 手机号码
     */
    private String phone;


    /**
     * 人员类型，1内勤人员，2普通保安员，3武装押运人员
     */
    private String personType;

    /**
     * 激活状态 0 未激活 1已激活
     */
    private String init;

    /***
     *是否身份认证 0 未认证 1已认证
     */
    private String identityAuthState;

    /**
     * 部门
     */
    private String departName;
}
