package com.bcxin.ars.dto.page;

import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.model.ComStateChangeLog;
import lombok.Data;

import java.util.Date;


/**
 * 自招单位状态变更日志查询dto
 *
 * @author lin
 * @date 2020-11-04
 */
@Data
public class ComStateChangeLogPageSearchDto extends SearchDto<ComStateChangeLog> {
    private static final long serialVersionUID = 1L;


    /**
     * 主键id
     */
    private Long id;

    /**
     * 更新标识
     */
    private Boolean updateflag;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 修改时间
     */
    private Date updateTime;

    /**
     * 操作者
     */
    private String updateBy;

    /**
     * 操作者id
     */
    private Long userId;

    /**
     * 公司id
     */
    private Long comId;
    
    /**
     * 公司名称
     */
    private String comName;
    
    /**
     * 旧状态
     */
    private String oldState;
    
    /**
     * 新状态
     */
    private String newState;
    
    /**
     * 开始时间
     */
    private String startDate;

    /**
     * 结束时间
     */
    private String endDate;
}
