package com.bcxin.ars.dto.page;

import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.model.AnnualSurveyReport;
import lombok.Data;


/**
 * 北京保安从业单位和从业人员情况年度调查查询dto
 *
 * @author lin
 * @date 2020-11-20
 */
@Data
public class AnnualSurveyReportPageSearchDto extends SearchDto<AnnualSurveyReport> {
    private static final long serialVersionUID = 1L;

    /**
     * 区域编码
     */
    private String areaCode;
    
    /**
     * 公安机构id
     */
    private Long orgId;
    
    /**
     * 操作者id
     */
    private Long userId;
    
    /**
     * 公司id
     */
    private Long comId;
    
    /**
     * 年度
     */
    private String fillYear;

    /**
     * 公司名称
     */
    private String comName;

    /**
     * 填写人
     */
    private String realName;
    
    /**
     * 联系电话
     */
    private String phone;
    
    /**
     * 创建开始时间
     */
    private String startCreateDate;

    /**
     * 创建结束时间
     */
    private String endCreateDate;

    /**
     * 更新开始时间
     */
    private String startDate;

    /**
     * 更新结束时间
     */
    private String endDate;
}
