package com.bcxin.ars.dto.gx;

import com.bcxin.ars.model.sb.SbSponsorlicenseManager;
import com.bcxin.ars.model.sb.SbSponsorlicenseVmanager;
import com.bcxin.ars.model.sb.Shareholder;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @Auther linqinglin
 * @date 2022/4/12 21:48
 */
@Data
public class SecCompanyDto implements Serializable {

    private static final long serialVersionUID = 2220082166930076300L;

    /**
     * 公司名称
     */
    String companyname;

    /**
     * 电话
     */
    private String tel;

    /**
     * 公司地址
     */
    private String address;

    /**
     * 邮编
     */
    private String zipcode;

    /**
     * 经营范围
     * securityScopeType
     */
    private String management;

    /**
     * 企业类型
     */
    private String enterprisetype;

    /**
     * 注册资本
     */
    private Integer regcapital;

    /**
     * 注册资本验资或评估机构
     */
    private String assessmentorg;

    /**
     * 货币资本
     */
    private Integer currency;

    /**
     * 货币资本百分比
     */
    private String currencybf;
    /**
     * 货币评估资本百分比
     */
    private String currencyvaluebf;

    /**
     *货币评估资本
     */
    private Integer currencyvalue;

    /**
     * 法人姓名
     */
    private String representative;

    /**
     *法人代表手机号
     */
    private String phone;

    /**
     * 法人身份证号
     */
    private String legalPersonNo;
    /**
     * 公司管理人员数
     */
    private Integer companymanger;

    /**
     *专业技术人员数
     */
    private Integer technologynum;

    /**
     * 公司用户面积
     */
    private String areanum;

    /**
     * 产权归属
     */
    private String ascription;

    /**
     * 专属运输车辆数
     */
    private Integer ascriptionvehicle;

    /**
     * 防暴枪支数
     */
    private Integer gunnum;

    /**
     * 保安服务许可类型
     */
    private String sponsorlicenseType;

    /**
     * 所在地县（区）代码
     **/
    private String district;
    /**
     * 附件
     */
    private String templateRar;
    /**
     * 数据来源
     */
    private String dataSource;


    //添加股东出资金额及所占比例
    private List<Shareholder> shareholderList;
    //公司总经理信息
    private List<SbSponsorlicenseManager> generalList;
    //公司副总经理信息
    private List<SbSponsorlicenseVmanager> viceGeneralList;

}
