package com.bcxin.ars.dto.export;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.bcxin.ars.enums.SignType;
import com.bcxin.ars.model.BaseModel;
import com.bcxin.ars.model.Police;
import com.bcxin.ars.model.sys.Approval;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 *sb_subsidiary
 *
 */
@Data
public class SubsidiaryExportDTO extends BaseModel {

	/**  */
	private static final long serialVersionUID = 6591290095390608015L;
	/**
	 *子公司名称
	 */
	@ModelAnnotation(getName="子公司名称",column = "Soncompanyname",isExport =true,defaultColumn=true)
	private String soncompanyname;

    /**
    *公司名称
    */
	@ModelAnnotation(getName="总公司名称",column = "Companyname",isExport =true,defaultColumn=true)
    private String companyname;
	/**
	 * 提交时间（审批表）
	 */
	@ModelAnnotation(getName="提交时间",column = "create_time",isExport = true,defaultColumn=true,anotherTable=true)
	private Date createTime;
	/**
	 *法人姓名
	 */
	@ModelAnnotation(getName="法人姓名",column = "Legalname",isExport =true,defaultColumn=true)
	private String legalname;
	/**
	 *法人手机号
	 */
	@ModelAnnotation(getName="法人手机号",column = "Legalphone",isExport =true,defaultColumn=true)
	private String legalphone;
	/**
	 *审批状态
	 */
	@ModelAnnotation(getName="审批状态",column = "approvalstate",isExport =true,defaultColumn=true,needTranslate = true,dictName = "approvalState")
	private String approvalstate;

	/**
	 *法人性别
	 */
	@ModelAnnotation(getName="法人性别",column = "Legalsex",isExport =true,needTranslate = true,dictName = "sex")
	private String legalsex;

	/**
	 *法人民族
	 */
	@ModelAnnotation(getName="法人民族",column = "Legalnation",isExport =true,needTranslate = true,dictName = "nation")
	private String legalnation;

	/**
	 *法人出生年月
	 */
	@ModelAnnotation(getName="法人出生年月",column = "Legalbirth",isExport =true)
	private Date legalbirth;

	/**
	 *法人政治面貌
	 */
	@ModelAnnotation(getName="法人政治面貌",column = "legalPolitics",isExport =true,needTranslate = true,dictName = "politics")
	private String legalpolitics;

	/**
	 *法人文化程度
	 */
	@ModelAnnotation(getName="法人文化程度",column = "legalCulture",isExport =true,needTranslate = true,dictName = "edu")
	private String legalculture;

	/**
	 *法人办公电话
	 */
	@ModelAnnotation(getName="法人办公电话",column = "Legaltel",isExport =true)
	private String legaltel;



	/**
	 *法人国籍
	 */
	@ModelAnnotation(getName="法人国籍",column = "Legalnationality",isExport =true)
	private String legalnationality;

	/**
	 *法人证件类型
	 */
	@ModelAnnotation(getName="法人证件类型",column = "Legaltype")
	private String legaltype;

	/**
	 *法人证件号码
	 */
	@ModelAnnotation(getName="法人证件号码",column = "Legalcardnumber",isExport =true)
	private String legalcardnumber;

	/**
	 *法人实际居住地址
	 */
	@ModelAnnotation(getName="法人实际居住地址",column = "Legaladdress",isExport =true)
	private String legaladdress;

	/**
	 *法人户籍所在址/境外地址
	 */
	@ModelAnnotation(getName="法人户籍所在址/境外地址",column = "legalAbroadaddress",isExport =true)
	private String legalabroadaddress;
    /**
    *保安服务许可证号
    */
	@ModelAnnotation(getName="保安服务许可证号",column = "Licencenum",isExport =true)
    private String licencenum;

    /**
    *公司地址
    */
	@ModelAnnotation(getName="公司地址",column = "Address",isExport =true)
    private String address;

    /**
    *统一信用代码
    */
	@ModelAnnotation(getName="统一信用代码",column = "Creditcode",isExport =true)
    private String creditcode;

    /**
    *保安员数
    */
	@ModelAnnotation(getName="保安员数",column = "Personnum",isExport =true)
    private Integer personnum;

    /**
    *邮编
    */
	@ModelAnnotation(getName="邮编",column = "Zipcode",isExport =true)
    private String zipcode;



	/**所在地省市县（区）**/
	@ModelAnnotation(getName="所在地省市县（区）",column = "szss",isExport =true )
	private String szss;

	/**所在地省代码**/
	@ModelAnnotation(getName="所在地省代码",column = "province")
	private String province;

	/**所在地市代码**/
	@ModelAnnotation(getName="所在地市代码",column = "city")
	private String city;

	/**所在地县（区）代码**/
	@ModelAnnotation(getName="所在地县（区）代码",column = "district",sign = SignType.LIKE)
	private String district;

	/**
	 * 派出所ID
	 */
	@ModelAnnotation(getName="派出所ID",column = "orgid")
	private Long orgid;



    /**
    *子公司地址
    */
	@ModelAnnotation(getName="子公司地址",column = "Sonaddrss",isExport =true)
    private String sonaddrss;

    /**
    *子公司拟开展保安服务项目
    */
	@ModelAnnotation(getName="子公司拟开展保安服务项目",column = "Sonproject",isExport =true)
    private String sonproject;

    /**
    *负责人姓名
    */
	@ModelAnnotation(getName="负责人姓名",column = "Chargename",isExport =true)
    private String chargename;

    /**
    *负责人职务
    */
	@ModelAnnotation(getName="负责人职务",column = "Chargepost",isExport =true)
    private String chargepost;

    /**
    *负责人居民身份证号码
    */
	@ModelAnnotation(getName="负责人居民身份证号码",column = "Chargecardnumber",isExport =true)
    private String chargecardnumber;

    /**
    *负责人联系电话
    */
	@ModelAnnotation(getName="负责人联系电话",column = "Chargephone",isExport =true)
    private String chargephone;

    /**
    *子公司保安人数
    */
	@ModelAnnotation(getName="子公司保安人数",column = "Sonpersonnum",isExport =true)
    private Integer sonpersonnum;

    /**
    *子公司邮编
    */
	@ModelAnnotation(getName="子公司邮编",column = "Sonzipcode",isExport =true)
    private String sonzipcode;

    /**
	 * 压缩包地址
	 */
	@ModelAnnotation(getName="压缩包地址",column = "template_rar")
	private String templateRar;
	
    /**
    *用户ID
    */
	@ModelAnnotation(getName="用户ID",column = "userid")
    private Long userid;


	/**
	 *审批意见
	 */
	private String outreason;

    /**
    *审批人
    */
	/*@ModelAnnotation(getName="审批人",column = "Approvalperson",isExport =true)*/
    private String approvalperson;

    /**
    *审批时间
    */
	/*@ModelAnnotation(getName="审批时间",column = "approvaldate",isExport =true)*/
    private Date approvaldate;

    /**
    *审批原因
    */
	/*@ModelAnnotation(getName="审批原因",column = "approvalreason",isExport =true)*/
    private String approvalreason;
	/**
	 * 审批信息列表
	 */
	private List approvallist;


	/**
	 * 法人审核状态
	 */
	@ModelAnnotation(getName="法人审核状态",column = "legalcensorstatus",isExport =true,needTranslate = true,dictName = "censorstatus")
	private String legalcensorstatus;

	/**
	 *单位负责人审查状态(0 未审查 1 审查通过 2审查不通过）
	 */
	@ModelAnnotation(getName="单位负责人审查状态",column = "chargecensorstatus")
	private String chargecensorstatus;

	/**
	 * 派出所信息
	 */
	private Police police;

	/**
	 * 待办事项
	 */
	private Approval approval;

	public Approval getApproval() {
		return approval;
	}

	public void setApproval(Approval approval) {
		this.approval = approval;
	}

	public Police getPolice() {
		return police;
	}

	public void setPolice(Police police) {
		this.police = police;
	}

	public String getLegalcensorstatus() {
		return legalcensorstatus;
	}

	public void setLegalcensorstatus(String legalcensorstatus) {
		this.legalcensorstatus = legalcensorstatus;
	}

	public String getChargecensorstatus() {
		return chargecensorstatus;
	}

	public void setChargecensorstatus(String chargecensorstatus) {
		this.chargecensorstatus = chargecensorstatus;
	}

	public List getApprovallist() {
		return approvallist;
	}

	public void setApprovallist(List approvallist) {
		this.approvallist = approvallist;
	}
	/**
	 *公司名称
	 */
	public String getCompanyname(){
		return this.companyname;
	}
	
	/**
	 *公司名称
	 */
	public void setCompanyname(String companyname){
		this.companyname = companyname;
	}
	/**
	 *保安服务许可证号
	 */
	public String getLicencenum(){
		return this.licencenum;
	}
	
	/**
	 *保安服务许可证号
	 */
	public void setLicencenum(String licencenum){
		this.licencenum = licencenum;
	}
	/**
	 *公司地址
	 */
	public String getAddress(){
		return this.address;
	}
	
	/**
	 *公司地址
	 */
	public void setAddress(String address){
		this.address = address;
	}
	/**
	 *统一信用代码
	 */
	public String getCreditcode(){
		return this.creditcode;
	}
	
	/**
	 *统一信用代码
	 */
	public void setCreditcode(String creditcode){
		this.creditcode = creditcode;
	}
	/**
	 *保安员数
	 */
	public Integer getPersonnum(){
		return this.personnum;
	}
	
	/**
	 *保安员数
	 */
	public void setPersonnum(Integer personnum){
		this.personnum = personnum;
	}
	/**
	 *邮编
	 */
	public String getZipcode(){
		return this.zipcode;
	}
	
	/**
	 *邮编
	 */
	public void setZipcode(String zipcode){
		this.zipcode = zipcode;
	}
	/**
	 *法人姓名
	 */
	public String getLegalname(){
		return this.legalname;
	}
	
	/**
	 *法人姓名
	 */
	public void setLegalname(String legalname){
		this.legalname = legalname;
	}
	/**
	 *法人性别
	 */
	public String getLegalsex(){
		return this.legalsex;
	}
	
	/**
	 *法人性别
	 */
	public void setLegalsex(String legalsex){
		this.legalsex = legalsex;
	}
	/**
	 *法人民族
	 */
	public String getLegalnation(){
		return this.legalnation;
	}
	
	/**
	 *法人民族
	 */
	public void setLegalnation(String legalnation){
		this.legalnation = legalnation;
	}
	/**
	 *法人出生年月
	 */
	public Date getLegalbirth(){
		return this.legalbirth;
	}
	
	/**
	 *法人出生年月
	 */
	public void setLegalbirth(Date legalbirth){
		this.legalbirth = legalbirth;
	}
	/**
	 *法人政治面貌
	 */
	public String getLegalpolitics(){
		return this.legalpolitics;
	}
	
	/**
	 *法人政治面貌
	 */
	public void setLegalpolitics(String legalpolitics){
		this.legalpolitics = legalpolitics;
	}
	/**
	 *法人文化程度
	 */
	public String getLegalculture(){
		return this.legalculture;
	}
	
	/**
	 *法人文化程度
	 */
	public void setLegalculture(String legalculture){
		this.legalculture = legalculture;
	}
	/**
	 *法人办公电话
	 */
	public String getLegaltel(){
		return this.legaltel;
	}
	
	/**
	 *法人办公电话
	 */
	public void setLegaltel(String legaltel){
		this.legaltel = legaltel;
	}
	/**
	 *
	 */
	public String getLegalphone(){
		return this.legalphone;
	}
	
	/**
	 *
	 */
	public void setLegalphone(String legalphone){
		this.legalphone = legalphone;
	}
	/**
	 *法人国籍
	 */
	public String getLegalnationality(){
		return this.legalnationality;
	}
	
	/**
	 *法人国籍
	 */
	public void setLegalnationality(String legalnationality){
		this.legalnationality = legalnationality;
	}
	/**
	 *法人证件类型
	 */
	public String getLegaltype(){
		return this.legaltype;
	}
	
	/**
	 *法人证件类型
	 */
	public void setLegaltype(String legaltype){
		this.legaltype = legaltype;
	}
	/**
	 *法人证件号码
	 */
	public String getLegalcardnumber(){
		return this.legalcardnumber;
	}
	
	/**
	 *法人证件号码
	 */
	public void setLegalcardnumber(String legalcardnumber){
		this.legalcardnumber = legalcardnumber;
	}
	/**
	 *法人实际居住地址
	 */
	public String getLegaladdress(){
		return this.legaladdress;
	}
	
	/**
	 *法人实际居住地址
	 */
	public void setLegaladdress(String legaladdress){
		this.legaladdress = legaladdress;
	}
	/**
	 *法人户籍所在址/境外地址
	 */
	public String getLegalabroadaddress(){
		return this.legalabroadaddress;
	}
	
	/**
	 *法人户籍所在址/境外地址
	 */
	public void setLegalabroadaddress(String legalabroadaddress){
		this.legalabroadaddress = legalabroadaddress;
	}
	/**
	 *子公司名称
	 */
	public String getSoncompanyname(){
		return this.soncompanyname;
	}
	
	/**
	 *子公司名称
	 */
	public void setSoncompanyname(String soncompanyname){
		this.soncompanyname = soncompanyname;
	}
	/**
	 *子公司地址
	 */
	public String getSonaddrss(){
		return this.sonaddrss;
	}
	
	/**
	 *子公司地址
	 */
	public void setSonaddrss(String sonaddrss){
		this.sonaddrss = sonaddrss;
	}
	/**
	 *子公司拟开展保安服务项目
	 */
	public String getSonproject(){
		return this.sonproject;
	}
	
	/**
	 *子公司拟开展保安服务项目
	 */
	public void setSonproject(String sonproject){
		this.sonproject = sonproject;
	}
	/**
	 *负责人姓名
	 */
	public String getChargename(){
		return this.chargename;
	}
	
	/**
	 *负责人姓名
	 */
	public void setChargename(String chargename){
		this.chargename = chargename;
	}
	/**
	 *负责人职务
	 */
	public String getChargepost(){
		return this.chargepost;
	}
	
	/**
	 *负责人职务
	 */
	public void setChargepost(String chargepost){
		this.chargepost = chargepost;
	}
	/**
	 *负责人居民身份证号码
	 */
	public String getChargecardnumber(){
		return this.chargecardnumber;
	}
	
	/**
	 *负责人居民身份证号码
	 */
	public void setChargecardnumber(String chargecardnumber){
		this.chargecardnumber = chargecardnumber;
	}
	/**
	 *负责人联系电话
	 */
	public String getChargephone(){
		return this.chargephone;
	}
	
	/**
	 *负责人联系电话
	 */
	public void setChargephone(String chargephone){
		this.chargephone = chargephone;
	}
	/**
	 *子公司保安人数
	 */
	public Integer getSonpersonnum(){
		return this.sonpersonnum;
	}
	
	/**
	 *子公司保安人数
	 */
	public void setSonpersonnum(Integer sonpersonnum){
		this.sonpersonnum = sonpersonnum;
	}
	/**
	 *子公司邮编
	 */
	public String getSonzipcode(){
		return this.sonzipcode;
	}
	
	/**
	 *子公司邮编
	 */
	public void setSonzipcode(String sonzipcode){
		this.sonzipcode = sonzipcode;
	}
	/**
	 *用户ID
	 */
	public Long getUserid(){
		return this.userid;
	}
	
	/**
	 *用户ID
	 */
	public void setUserid(Long userid){
		this.userid = userid;
	}
	/**
	 *审批状态
	 */
	public String getApprovalstate(){
		return this.approvalstate;
	}
	
	/**
	 *审批状态
	 */
	public void setApprovalstate(String approvalstate){
		this.approvalstate = approvalstate;
	}
	/**
	 *审批人
	 */
	public String getApprovalperson(){
		return this.approvalperson;
	}

	public String getOutreason() {
		return outreason;
	}

	public void setOutreason(String outreason) {
		this.outreason = outreason;
	}

	/**
	 *审批人
	 */
	public void setApprovalperson(String approvalperson){
		this.approvalperson = approvalperson;
	}
	/**
	 *审批时间
	 */
	public Date getApprovaldate(){
		return this.approvaldate;
	}
	
	/**
	 *审批时间
	 */
	public void setApprovaldate(Date approvaldate){
		this.approvaldate = approvaldate;
	}
	/**
	 *审批原因
	 */
	public String getApprovalreason(){
		return this.approvalreason;
	}
	
	/**
	 *审批原因
	 */
	public void setApprovalreason(String approvalreason){
		this.approvalreason = approvalreason;
	}

	public String getTemplateRar() {
		return templateRar;
	}

	public void setTemplateRar(String templateRar) {
		this.templateRar = templateRar;
	}

	public String getSzss() {
		return szss;
	}

	public void setSzss(String szss) {
		this.szss = szss;
	}

	public String getProvince() {
		return province;
	}

	public void setProvince(String province) {
		this.province = province;
	}

	public String getCity() {
		return city;
	}

	public void setCity(String city) {
		this.city = city;
	}

	public String getDistrict() {
		return district;
	}

	public void setDistrict(String district) {
		this.district = district;
	}

	public Long getOrgid() {
		return orgid;
	}

	public void setOrgid(Long orgid) {
		this.orgid = orgid;
	}
	
}