package com.bcxin.ars.dto.export;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.abcxin.smart.validator.annotation.ModelTableAnnotation;
import com.bcxin.ars.enums.SignType;
import lombok.Data;

/**
 * 保安企业服务情况
 * @author subh
 */
@Data
@ModelTableAnnotation(extra = false)
public class SituationExportDto {
    @ModelAnnotation(column ="name",getName = "公司名称",isExport = true,sign= SignType.LIKE)
    private String name;
    @ModelAnnotation(column ="orgName",getName = "监管机构信息",isExport = true)
    private String orgName;
    @ModelAnnotation(column ="countPerson",getName = "人员数",isExport = true,sign= SignType.EQUAL)
    private String countPerson;
    @ModelAnnotation(column ="stationingNum",getName = "驻勤点",isExport = true,sign= SignType.EQUAL)
    private String stationingNum;
    @ModelAnnotation(column ="contractNum",getName = "企业服务合同",isExport = true)
    private String contractNum;
    @ModelAnnotation(column ="personContractNum",getName = "劳动合同",isExport = true)
    private String personContractNum;
    @ModelAnnotation(column ="unCertificate",getName = "未持证人数",isExport = true)
    private String unCertificate;
    //@ModelAnnotation(column ="noSchedulePersons",getName = "未安排驻勤点保安数",isExport = true)
    //private String noSchedulePersons;
    @ModelAnnotation(column ="isuredNumber",getName = "已投保保安数",isExport = true)
    private String isuredNumber;

    @ModelAnnotation(column ="areacode",getName = "所属区域",sign = SignType.LIKE)
    private String areaCode;
    @ModelAnnotation(column ="orgId",getName = "机构")
    private String orgId;

    /**
     * 保安师数
     */
    @ModelAnnotation(column ="securityGuardCount",getName = "保安师数",isExport = true)
    private int securityGuardCount;

    /**
     * 公司股东数
     */
    @ModelAnnotation(column ="managerCount",getName = "公司股东数",isExport = true)
    private int managerCount;
}
