package com.bcxin.ars.dto.export;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.bcxin.ars.model.BaseModel;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 保安师库
 *
 * @author wangjianchi
 */
@Data
public class SecurityGuardExportDTO extends BaseModel {

    private static final long serialVersionUID = -8650927699919560346L;
    /**
     * 身份证号
     */
    @ModelAnnotation(getName = "身份证号", column = "id_number", isExport = true)
    private String idNumber;

    /**
     * 姓名
     */
    @ModelAnnotation(getName = "姓名", column = "name", isExport = true)
    private String name;

    /**
     * 性别
     */
    @ModelAnnotation(getName = "性别", column = "sex", isExport = true,needTranslate = true,dictName = "sex")
    private String sex;

    /**
     * 职业
     */
    @ModelAnnotation(getName = "职业", column = "profession", isExport = true,needTranslate = true,dictName = "profession")
    private String profession;

    /**
     * 职业级别
     */
    @ModelAnnotation(getName = "职业级别", column = "profession_level", isExport = true,needTranslate = true,dictName = "professionLevel")
    private String professionLevel;

    /**
     * 文化程度
     */
    @ModelAnnotation(getName = "文化程度", column = "edu", isExport = true,needTranslate = true,dictName = "edu")
    private String edu;

    /**
     * 服务开始时间
     */
    @ModelAnnotation(getName = "服务开始时间", column = "serviceStartTime", isExport = true)
    private String serviceStartTime;

    /**
     * 服务结束时间
     */
    @ModelAnnotation(getName = "服务结束时间", column = "serviceEndTime", isExport = true)
    private String serviceEndTime;


    /**
     * 联系电话
     */
    @ModelAnnotation(getName = "联系电话", column = "phone", isExport = true)
    private String phone;

    /**
     * 证书编号
     */
    @ModelAnnotation(getName = "证书编号", column = "credential", isExport = true)
    private String credential;

    /***
     * 颁证日期
     */
    @ModelAnnotation(getName = "颁证日期", column = "certificatejgtime", isExport = true)
    private String certificatejgtime;

    /***
     * 服务保安公司
     */
    @ModelAnnotation(getName = "服务保安公司", column = "security_company", isExport = true)
    private String securityCompany;

    /***
     * 培训机构
     */
    @ModelAnnotation(getName = "培训机构", column = "trainName", isExport = true)
    private String trainName;

    /***
     * 工作地点
     */
    @ModelAnnotation(getName = "工作地点", column = "workPlace", isExport = true)
    private String workPlace;

    /***
     * 准考证号
     */
    @ModelAnnotation(getName = "准考证号", column = "ticketNum", isExport = true)
    private String ticketNum;

    /***
     * 理论成绩
     */
    @ModelAnnotation(getName = "理论成绩", column = "written_score",isExport = true)
    private Integer writtenScore;

    /***
     * 体能成绩
     */
    @ModelAnnotation(getName = "体能成绩", column = "operate_score",isExport = true)
    private Integer operateScore;

    /***
     * 综合成绩
     */
    @ModelAnnotation(getName = "综合成绩", column = "sum_score",isExport = true)
    private BigDecimal sumScore;
}
