package com.bcxin.ars.dto.export;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.abcxin.smart.validator.annotation.ModelTableAnnotation;
import com.bcxin.ars.enums.SignType;
import com.bcxin.ars.model.BaseModel;
import lombok.Data;

/**
 * sb_personcertificate 保安员证考试报名打印
 */
@Data
@ModelTableAnnotation(areaCodeFilterColumn = "areaCode")
public class SecurityCertificateExportPrintDTO extends BaseModel {

	/**  */
	private static final long serialVersionUID = 8556407864044628410L;

	/**
	 * 姓名
	 */
	@ModelAnnotation(getName = "姓名",isExport = true,column = "xm",defaultColumn=true,sign = SignType.LIKE)
	private String name;

	/**
	 * 姓名
	 */
	@ModelAnnotation(getName = "性别",isExport = true,column = "sex",needTranslate = true,dictName="sex")
	private String sex;

	/**
	 * 身份证号码
	 */
	@ModelAnnotation(getName = "身份证号码",isExport = true,column = "idnum",defaultColumn=true,sign = SignType.LIKE)
	private String cardnumber;

	/**
	 * 手机号
	 */
	@ModelAnnotation(getName = "手机号",isExport = true,column = "phone",sign = SignType.EQUAL_NULL_ZERO)
	private String phone;

	/**
	 * 出生年月
	 */
	@ModelAnnotation(getName = "出生年月",isExport = true,column = "csrq")
	private String brith;

	@ModelAnnotation(getName="地址",column = "companyName",sign = SignType.LIKE,isExport = true)
	private String address;

	/**
	 * 发证日期
	 */
	@ModelAnnotation(getName="发证日期",column = "fzrq",isExport = true,defaultColumn = true)
	private String fzrq;

	/***
	 * 发证日期开始日期
	 */
	@ModelAnnotation(getName="发证日期",column = "fzrq",sign = SignType.DATE_GREATER_EQUAL)
	private String startDate;
	/***
	 * 发证日期结束日期
	 */
	@ModelAnnotation(getName="发证日期",column = "fzrq",sign = SignType.DATE_LESS_EQUAL)
	private String endDate;

	/**
	 * 是否打印
	 */
	@ModelAnnotation(getName = "是否打印",column = "isprint",needTranslate = true,dictName="hasprint")
	private String isprint;

	/**
	 * 是否有照片 0 否 1 是
	 */
	@ModelAnnotation(getName = "是否有照片",isExport = true, dictName ="havephoto",column = "havephoto",needTranslate = true)
	private String havephoto;

	@ModelAnnotation(getName = "是否旧数据",isExport = true,column = "isolddata",dictName ="isolddata",defaultColumn=true,needTranslate = true,sign = SignType.OLDDATA_TRAINID)
	private String oldData;

	/**
	 * 培训机构ID
	 */
	@ModelAnnotation(getName="培训机构ID",column = "trainId",sign = SignType.OLDDATA_TRAINID)
	private String trainId;
	/**
	 * 保安员证号
	 */
	@ModelAnnotation(getName="证书编号",column = "zsbh",isExport = true,defaultColumn = true,sign = SignType.LIKE)
	private String zsbh;

	/**
	 * 打印次数
	 */
	@ModelAnnotation(getName="打印次数",column = "printcount")
	private String printcount;
	/**
	 * 打印日期
	 */
	@ModelAnnotation(getName="打印日期",column = "printTime")
	private String printTime;

	/**
	 * 2018年8月15日16:50:33 wjb 所属公司名称
	 */
	@ModelAnnotation(getName="报名所在单位",column = "companyName",sign = SignType.LIKE,isExport = true,defaultColumn=true)
	private String companyName;
	/*@ModelAnnotation(getName="所属公司名称",column = "sc_name",sign = SignType.LIKE,isExport = true,defaultColumn=true,anotherTable = true)
	private String scName;*/

	/**
	 * 发证机关
	 */
	@ModelAnnotation(getName="发证机关",column = "fzjgmc",isExport = true)
	private String fzjgmc;



}