package com.bcxin.ars.dto.export;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.bcxin.ars.enums.SignType;
import lombok.Data;

@Data
public class PersonComplaintExportDto {
    /** 公司类型 */
    @ModelAnnotation(getName="公司类型",column = "institutionType",isExport = true,needTranslate = true,dictName ="institutionType")
    private String institutionType;

    /** 投诉人姓名 */
    @ModelAnnotation(getName = "投诉人姓名 ",column = "complainter",isExport = true,sign = SignType.LIKE)
    private String complainter;

    /** 投诉人证件号码 */
    @ModelAnnotation(getName = "投诉人证件号码",column = "idnum",isExport = true)
    private String idnum;

    /** 投诉人证件类型 */
    @ModelAnnotation(getName = "投诉人证件类型",column = "id_type",isExport = true,needTranslate = true,dictName = "idType")
    private String idType;

    /** 投诉人联系电话 */
    @ModelAnnotation(getName = "投诉人联系电话",column = "complainter_phone",isExport = true)
    private String complainterPhone;

    /** 投诉人公司名称 */
    @ModelAnnotation(getName = "投诉人公司名称 ",column = "company_name",isExport = true,sign = SignType.LIKE)
    private String companyName;

    /** 被投诉保安员 */
    @ModelAnnotation(getName = "被投诉保安员 ",column = "complaint_person",isExport = true,sign = SignType.LIKE)
    private String complaintPerson;

    /** 受理时间 */
    @ModelAnnotation(getName = "受理时间",column = "accept_date",isExport = true)
    private String acceptDate;

    /** 受理机构 */
    @ModelAnnotation(getName = "受理机构 ",column = "accept_org_name",isExport = true,sign = SignType.LIKE)
    private String acceptOrgName;
    /** 受理机构id */
    @ModelAnnotation(getName = "受理机构",column = "accept_org_id")
    private String acceptOrgId;
    @ModelAnnotation(getName = "公安areaCode",column = "orgAreaCode",sign = SignType.LIKE_AREACODE)
    private String orgAreaCode;
    /** 受理人 */
    @ModelAnnotation(getName = "受理人",column = "accepter",isExport = true)
    private String accepter;

    /** 处理时间 */
    @ModelAnnotation(getName = "处理时间",column = "disposal_date",isExport = true)
    private String disposalDate;

    /** 处理机构 */
    @ModelAnnotation(getName = "处理机构 ",column = "disposal_org_name",isExport = true)
    private String disposalOrgName;

    /** 处理决定人 */
    @ModelAnnotation(getName = "处理决定人 ",column = "disposaler",isExport = true)
    private String disposaler;

    /** 投诉原因 */
    @ModelAnnotation(getName = "投诉原因 ",column = "reason",isExport = true)
    private String reason;

    /** 处理意见 */
    @ModelAnnotation(getName = "处理意见 ",column = "disposal",isExport = true)
    private String disposal;

    /** 整改要求 */
    @ModelAnnotation(getName = "整改要求 ",column = "rectify_require",isExport = true)
    private String rectifyRequire;

    /** 复查情况 */
    @ModelAnnotation(getName = "复查情况 ",column = "review",isExport = true)
    private String review;

    /** 数据来源 */
    @ModelAnnotation(getName="数据来源",column = "dataSource",isExport = true,needTranslate = true,dictName ="dataSource")
    private String dataSource;

    /** 被检查人签名 */
    @ModelAnnotation(getName = "被检查人签名",column = "signImgPath",isExport = true)
    private String signImgPath;
}
