package com.bcxin.ars.dto.export;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.abcxin.smart.validator.annotation.ModelTableAnnotation;
import com.bcxin.ars.enums.SignType;
import com.bcxin.ars.model.BaseModel;
import com.bcxin.ars.model.Police;
import com.bcxin.ars.model.sys.Approval;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * sb_legalchange
 * 法人变更
 * <b>Function </b>
 *
 * @author LinQingLin
 * @date 2017年5月20日 下午12:36:31
 * @注意事项 </b>
 * <b>
 */
@Data
@ModelTableAnnotation(areaCodeFilter="1")
public class LegalchangeExportVDTO extends BaseModel {

    /**  */
    private static final long serialVersionUID = -2892981931790662070L;

    /**
     * 公司名称
     */
    @ModelAnnotation(getName="公司名称",isExport = true,column  = "companyname",defaultColumn = true,sign = SignType.LIKE)
    private String companyname;
    /**
     * 审批状态
     * 001未提交002待审核003审批通过004审批不通过
     */
    @ModelAnnotation(getName="审批状态",isExport = true,column  = "approvalstate",defaultColumn = true,needTranslate = true,dictName = "approvalState")
    private String approvalstate;
    /**
     * 提交日期（审批表）
     */
    @ModelAnnotation(getName="提交日期",column = "createTime",isExport = true,defaultColumn=true)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date createTime;
    /**
     * 更新时间
     */
    @ModelAnnotation(getName="更新时间",column = "updateTime",isExport = true,defaultColumn=true)
    private Date updateTime;
    /** 提交时间查询开始时间 */
    @ModelAnnotation(getName="提交时间查询开始时间",column = "createTime",sign = SignType.DATE_GREATER_EQUAL)
    private String searchStartTime;

    /** 提交时间查询结束时间 */
    @ModelAnnotation(getName="提交时间查询结束时间",column = "createTime",sign = SignType.DATE_LESS_EQUAL)
    private String searchEndTime;
    /**
     * 变更项目
     *
     */
    @ModelAnnotation(getName="变更项目",isExport = true,column  = "changeName",defaultColumn = true)
    private String changeName;
    /**
     * 法人姓名
     */
    @ModelAnnotation(getName="法人姓名",isExport = true,column  = "legalname",defaultColumn = true,sign = SignType.LIKE)
    private String legalname;
    /**
     * 法人手机号（user表）
     */
    @ModelAnnotation(getName="法人手机号",column = "legalphone",isExport = true,defaultColumn=true,sign = SignType.LIKE)
    private String legalphone;
    /**
     * 公司地址
     */
    @ModelAnnotation(getName="公司地址",isExport = true,column  = "address")
    private String address;

    /**所在地县（区）代码**/
    @ModelAnnotation(getName="所在地县（区）代码",column  = "district",sign = SignType.LIKE)
    private String areaCode;

    /**
     * 下一审批人
     */
    @ModelAnnotation(getName="下一审批人",isExport = true,column  = "nextPerson")
    private String nextPerson;

    /**
     * 许可证
     */
    @ModelAnnotation(getName="许可证",isExport = true,column  = "licencenum")
    private String licencenum;

    /**
     * 法人性别
     */
    @ModelAnnotation(getName="法人性别",isExport = true,column  = "legalsex",needTranslate = true,dictName = "sex")
    private String legalsex;

    /**
     * 任职时间
     */
    @ModelAnnotation(getName="任职时间",isExport = true,column  = "officetime")
    private Date officetime;
    /**
     * 原服务范围
     */
    @ModelAnnotation(getName="原服务范围",isExport = true,column  = "oldsecurityScopes",needTranslate = true,dictName = "securityScopeType",multipleCode = true,multipleCodeTableName = "v_sb_legalchange")
    private String oldsecurityScopes;

    /**
     * 变更后服务范围
     */
    @ModelAnnotation(getName="变更后服务范围",isExport = true,column  = "securityScopes",needTranslate = true,dictName = "securityScopeType",multipleCode = true,multipleCodeTableName = "v_sb_legalchange")
    private String securityScopes;
    /**
     * 证件类型
     */
    @ModelAnnotation(getName="证件类型",isExport = true,column  = "legalcardtype",needTranslate = true,dictName = "idCardType")
    private String legalcardtype;

    /**
     * 法人证件号码
     */
    @ModelAnnotation(getName="法人证件号码",isExport = true,column  = "legalcardnumber")
    private String legalcardnumber;
    /**
     * 拟定法人名称
     */
    @ModelAnnotation(getName="拟定法人名称",isExport = true,column  = "ndlegalname")
    private String ndlegalname;

    /**
     * 拟定法人性别
     */
    @ModelAnnotation(getName="拟定法人性别",isExport = true,column  = "ndlegalsex",needTranslate = true,dictName = "sex")
    private String ndlegalsex;

    /**
     * 拟定出生年月
     */
    @ModelAnnotation(getName="拟定法人出生年月",isExport = true,column  = "ndlegalbrith")
    private Date ndlegalbrith;

    /**
     * 拟定法人文化程度
     */
    @ModelAnnotation(getName="拟定法人文化程度",isExport = true,column  = "ndlegalculture",needTranslate = true,dictName = "sex")
    private String ndlegalculture;

    /**
     * 拟定法人证件类型
     */
    @ModelAnnotation(getName="拟定法人证件类型",isExport = true,column  = "ndlegalcardtype",needTranslate = true,dictName = "idCardType")
    private String ndlegalcardtype;

    /**
     * 拟定法人证件号码
     */
    @ModelAnnotation(getName="拟定法人证件号码",isExport = true,column  = "ndlegalcardnum")
    private String ndlegalcardnum;

    /**
     * 拟定法人国籍
     */
    @ModelAnnotation(getName="拟定法人国籍",isExport = true,column  = "ndlegalnationality")
    private String ndlegalnationality;

    /**
     * 拟定法人手机号码
     */
    @ModelAnnotation(getName="拟定法人手机号码",isExport = true,column  = "ndlegalphone")
    private String ndlegalphone;

    /**
     * 拟定法人户籍所在地
     */
    @ModelAnnotation(getName="拟定法人户籍所在地",isExport = true,column  = "ndlegaladdress")
    private String ndlegaladdress;

    /**
     * 拟定法人实际地址
     */
    @ModelAnnotation(getName="拟定法人实际地址",isExport = true,column  = "ndleaglsjaddress")
    private String ndleaglsjaddress;

    /**
     * 用户ID
     */
    /*@ModelAnnotation(getName="用户ID",isExport = true,column  = "userid")*/
    private Long userid;


    /**
     * 审批数据
     *
     */
    private Approval approval;

    /**
     * 审批人
     */
    /*@ModelAnnotation(getName="审批人",isExport = true,column  = "approvalperson")*/
    private String approvalperson;

    /**
     * 审批原因
     */
    /*@ModelAnnotation(getName="审批原因",isExport = true,column  = "approvalreason")*/
    private String approvalreason;

    /**
     * 审批时间
     */
    /*@ModelAnnotation(getName="审批时间",isExport = true,column  = "approvaldate")*/
    private Date approvaldate;

    /**
     * 压缩包地址
     */
    @ModelAnnotation(getName="压缩包地址",isExport = true,column  = "template_rar")
    private String templateRar;


    /**所在地省市县（区）**/
    @ModelAnnotation(getName="所属区域",isExport = true,column  = "szss")
    private String szss;

    /**所在地省代码**/
   /* @ModelAnnotation(getName="所在地省代码",isExport = true,column  = "province")*/
    private String province;

    /**所在地市代码**/
    /*@ModelAnnotation(getName="所在地市代码",isExport = true,column  = "city")*/
    private String city;


    /**
     * 派出所ID
     */
    /*@ModelAnnotation(getName="派出所ID",isExport = true,column  = "orgid")*/
    private Long orgid;

    /**
     * 原法定代表人审查状态
     */
    @ModelAnnotation(getName="原法定代表人审查状态",isExport = true,column  = "legalcensorstatus",needTranslate = true,dictName = "censorstatus")
    private String legalcensorstatus;

    /**
     *拟定法定代表人审查状态
     */
    @ModelAnnotation(getName="拟定法定代表人审查状态",isExport = true,column  = "ndlegalcensorstatus",needTranslate = true,dictName = "censorstatus")
    private String ndlegalcensorstatus;

    /**
     *单位负责人审查状态(0 未审查 1 审查通过 2审查不通过）
     */
    @ModelAnnotation(getName="单位负责人审查状态",isExport = true,column  = "chargecensorstatus",needTranslate = true,dictName = "censorStatus")
    private String chargecensorstatus;

    /**
     * 原注册资本
     */
    @ModelAnnotation(getName="原注册资本",isExport = true,column  = "oldregisteredMoney")
    private String oldregisteredMoney;

    /**
     * 变更注册资本
     */
    @ModelAnnotation(getName="变更注册资本",isExport = true,column  = "bgregisteredMoney")
    private Double bgregisteredMoney;

    /**
     * 受理民警ID
     */
   /* @ModelAnnotation(getName="受理民警ID",isExport = true,column  = "policeid")*/
    private Long policeid;

    /***
     * 审批主键
     */
    private Long approvalId;

    /**
     * 派出所信息
     */
    private Police police;

    /**
     * 公司id
     */
    @ModelAnnotation(getName="公司id",isExport = true,column  = "companyid")
    private Long companyid;

    /**
     * 其他保安服务范围名称(保安范围为其他则此列必填)
     */
    @ModelAnnotation(getName="其他保安服务范围名称",isExport = true,column  = "otherSecScopeType")
    private String otherSecScopeType;

    /**
     * 审批信息列表
     */
    private List approvallist;
    /**
     * 原发证日期
     */
    @ModelAnnotation(getName="原发证日期",isExport = true,column  = "giveLicenseDate")
    private String giveLicenseDate;

    /**
     * 到期换证备注
     */
    @ModelAnnotation(getName="到期换证备注",isExport = true,column  = "expireRemarks")
    private String expireRemarks;

    /**
     * 原公司名称
     */
//    @ModelAnnotation(getName="原公司名称",isExport = true,column  = "oldcompanyname",defaultColumn = true)
    private String oldcompanyname;
}