package com.bcxin.ars.dto.export;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.bcxin.ars.enums.SignType;
import com.bcxin.ars.model.BaseModel;
import com.bcxin.ars.model.Police;
import com.bcxin.ars.model.sys.Approval;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * sb_legalchange
 * 法人变更
 * <b>Function </b>
 * 
 * @author LinQingLin
 * @date 2017年5月20日 下午12:36:31
 * @注意事项 </b>
 * <b>
 */
@Data
public class LegalchangeExportDTO extends BaseModel {

    /**  */
	private static final long serialVersionUID = -2892981931790662070L;




    /**
     * 原公司名称
     */
    @ModelAnnotation(getName="公司名称",isExport = true,column  = "oldcompanyname",defaultColumn = true,anotherTable = true)
    private String oldcompanyname;
    /**
     * 提交时间（审批表）
     */
    @ModelAnnotation(getName="提交时间",column = "create_time",isExport = true,defaultColumn=true,anotherTable=true)
    private Date createTime;
    /**
     * 变更项目
     *
     */
    @ModelAnnotation(getName="变更项目",isExport = true,column  = "changeProject",defaultColumn = true,needTranslate = true,specialTranslateType = "3",dictName = "changeProject")
    private String changeProject;
    /**
     * 法人姓名
     */
    @ModelAnnotation(getName="法人姓名",isExport = true,column  = "legalname",defaultColumn = true)
    private String legalname;
    /**
     * 法人手机号（user表）
     */
    @ModelAnnotation(getName="法人手机号",column = "phone",isExport = true,defaultColumn=true,anotherTable=true)
    private String phone;
    /**
     * 审批状态
     * 001未提交002待审核003审批通过004审批不通过
     */
    @ModelAnnotation(getName="审批状态",isExport = true,column  = "approvalstate",defaultColumn = true,needTranslate = true,dictName = "approvalState")
    private String approvalstate;
    /**
     * 原服务范围
     */
    @ModelAnnotation(getName="原服务范围",isExport = true,column  = "oldsecurityScopes")
    private String oldsecurityScopes;

    /**
     * 变更后服务范围
     */
    @ModelAnnotation(getName="变更后服务范围",isExport = true,column  = "securityScopes")
    private String securityScopes;



    /**
	 * 变更后公司名称
	 */
    @ModelAnnotation(getName="变更后公司名称",isExport = true,column  = "companyname")
	private String companyname;

	/**
	 * 原办公地址
	 */
    @ModelAnnotation(getName="原办公地址",isExport = true,column  = "address")
    private String oldaddress;

	/**
	 * 变更后办公地址
	 */
    @ModelAnnotation(getName="变更后办公地址",isExport = true,column  = "address")
    private String address;

	/**
	 * 许可证
	 */
    @ModelAnnotation(getName="许可证",isExport = true,column  = "licencenum")
    private String licencenum;



	/**
	 * 法人性别
	 */
    @ModelAnnotation(getName="法人性别",isExport = true,column  = "legalsex",needTranslate = true,dictName = "sex")
    private String legalsex;

	/**
	 * 任职时间
	 */
    @ModelAnnotation(getName="任职时间",isExport = true,column  = "officetime")
    private Date officetime;

	/**
	 * 证件类型
	 */
    @ModelAnnotation(getName="证件类型",isExport = true,column  = "legalcardtype",needTranslate = true,dictName = "idCardType")
    private String legalcardtype;

	/**
	 * 法人证件号码
	 */
    @ModelAnnotation(getName="法人证件号码",isExport = true,column  = "legalcardnumber")
    private String legalcardnumber;

	/**
	 * 拟定法人名称
	 */
    @ModelAnnotation(getName="拟定法人名称",isExport = true,column  = "ndlegalname")
    private String ndlegalname;

	/**
	 * 拟定法人性别
	 */
    @ModelAnnotation(getName="拟定法人性别",isExport = true,column  = "ndlegalsex",needTranslate = true,dictName = "sex")
    private String ndlegalsex;

	/**
	 * 拟定出生年月
	 */
    @ModelAnnotation(getName="拟定出生年月",isExport = true,column  = "ndlegalbrith")
    private Date ndlegalbrith;

	/**
	 * 拟定法人文化程度
	 */
    @ModelAnnotation(getName="拟定法人文化程度",isExport = true,column  = "ndlegalculture",needTranslate = true,dictName = "sex")
    private String ndlegalculture;

	/**
	 * 拟定法人证件类型
	 */
    @ModelAnnotation(getName="拟定法人证件类型",isExport = true,column  = "ndlegalcardtype",needTranslate = true,dictName = "idCardType")
    private String ndlegalcardtype;

	/**
	 * 拟定法人证件号码
	 */
    @ModelAnnotation(getName="拟定法人证件号码",isExport = true,column  = "ndlegalcardnum")
    private String ndlegalcardnum;

	/**
	 * 拟定法人国籍
	 */
    @ModelAnnotation(getName="拟定法人国籍",isExport = true,column  = "ndlegalnationality")
    private String ndlegalnationality;

	/**
	 * 拟定法人手机号码
	 */
    @ModelAnnotation(getName="拟定法人手机号码",isExport = true,column  = "ndlegalphone")
    private String ndlegalphone;

	/**
	 * 拟定法人户籍所在地
	 */
    @ModelAnnotation(getName="拟定法人户籍所在地",isExport = true,column  = "ndlegaladdress")
    private String ndlegaladdress;

	/**
	 * 拟定法人实际地址
	 */
    @ModelAnnotation(getName="拟定法人实际地址",isExport = true,column  = "ndleaglsjaddress")
    private String ndleaglsjaddress;

	/**
	 * 用户ID
	 */
    @ModelAnnotation(getName="用户ID",isExport = true,column  = "userid")
    private Long userid;


    /**
     * 审批数据
     *
     */
    private Approval approval;

	/**
	 * 审批人
	 */
    @ModelAnnotation(getName="审批人",isExport = true,column  = "approvalperson")
    private String approvalperson;

	/**
	 * 审批原因
	 */
    @ModelAnnotation(getName="审批原因",isExport = true,column  = "approvalreason")
    private String approvalreason;

	/**
	 * 审批时间
	 */
    @ModelAnnotation(getName="审批时间",isExport = true,column  = "approvaldate")
    private Date approvaldate;
    
    /**
	 * 压缩包地址
	 */
    @ModelAnnotation(getName="压缩包地址",isExport = true,column  = "template_rar")
	private String templateRar;


    /**所在地省市县（区）**/
    @ModelAnnotation(getName="所在地省市县（区）",isExport = true,column  = "szss")
    private String szss;

    /**所在地省代码**/
    @ModelAnnotation(getName="所在地省代码",isExport = true,column  = "province")
    private String province;

    /**所在地市代码**/
    @ModelAnnotation(getName="所在地市代码",isExport = true,column  = "city")
    private String city;

    /**所在地县（区）代码**/
    @ModelAnnotation(getName="所在地县（区）代码",isExport = true,column  = "district",sign = SignType.LIKE)
    private String district;

    /**
     * 派出所ID
     */
    @ModelAnnotation(getName="派出所ID",isExport = true,column  = "orgid")
    private Long orgid;
    
    /**
     * 原法定代表人审查状态
     */
    @ModelAnnotation(getName="原法定代表人审查状态",isExport = true,column  = "legalcensorstatus",needTranslate = true,dictName = "censorstatus")
    private String legalcensorstatus;

    /**
     *拟定法定代表人审查状态
     */
    @ModelAnnotation(getName="拟定法定代表人审查状态",isExport = true,column  = "ndlegalcensorstatus",needTranslate = true,dictName = "censorstatus")
    private String ndlegalcensorstatus;

    /**
     *单位负责人审查状态(0 未审查 1 审查通过 2审查不通过）
     */
    @ModelAnnotation(getName="单位负责人审查状态",isExport = true,column  = "chargecensorstatus",needTranslate = true,dictName = "censorStatus")
    private String chargecensorstatus;

    /**
     * 原注册资本
     */
    @ModelAnnotation(getName="原注册资本",isExport = true,column  = "oldregisteredMoney")
    private String oldregisteredMoney;

    /**
     * 变更注册资本
     */
    @ModelAnnotation(getName="变更注册资本",isExport = true,column  = "bgregisteredMoney")
    private Double bgregisteredMoney;

    /**
     * 受理民警ID
     */
    @ModelAnnotation(getName="受理民警ID",isExport = true,column  = "policeid")
    private Long policeid;

    /***
     * 审批主键
     */
    private Long approvalId;

    /**
     * 派出所信息
     */
    private Police police;

    /**
     * 公司id
     */
    @ModelAnnotation(getName="公司id",isExport = true,column  = "companyid")
    private Long companyid;

    /**
     * 其他保安服务范围名称(保安范围为其他则此列必填)
     */
    @ModelAnnotation(getName="其他保安服务范围名称",isExport = true,column  = "otherSecScopeType")
    private String otherSecScopeType;

    public String getOtherSecScopeType() {
        return otherSecScopeType;
    }

    public void setOtherSecScopeType(String otherSecScopeType) {
        this.otherSecScopeType = otherSecScopeType;
    }

    public Police getPolice() {
        return police;
    }

    public void setPolice(Police police) {
        this.police = police;
    }

    public Long getApprovalId() {
        return approvalId;
    }

    public void setApprovalId(Long approvalId) {
        this.approvalId = approvalId;
    }

    public Double getBgregisteredMoney() {
        return bgregisteredMoney;
    }

    public void setBgregisteredMoney(Double bgregisteredMoney) {
        this.bgregisteredMoney = bgregisteredMoney;
    }

    public String getLegalcensorstatus() {
        return legalcensorstatus;
    }

    public void setLegalcensorstatus(String legalcensorstatus) {
        this.legalcensorstatus = legalcensorstatus;
    }

    public String getNdlegalcensorstatus() {
        return ndlegalcensorstatus;
    }

    public void setNdlegalcensorstatus(String ndlegalcensorstatus) {
        this.ndlegalcensorstatus = ndlegalcensorstatus;
    }

    public String getChargecensorstatus() {
        return chargecensorstatus;
    }

    public void setChargecensorstatus(String chargecensorstatus) {
        this.chargecensorstatus = chargecensorstatus;
    }

    public String getSzss() {
        return szss;
    }

    public void setSzss(String szss) {
        this.szss = szss;
    }

    public String getProvince() {
        return province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getDistrict() {
        return district;
    }

    public void setDistrict(String district) {
        this.district = district;
    }
    /**
     * 审批信息列表
     */
    private List approvallist;


    public List getApprovallist() {
        return approvallist;
    }

    public void setApprovallist(List approvallist) {
        this.approvallist = approvallist;
    }

    public String getCompanyname() {
        return companyname;
    }

    public void setCompanyname(String companyname) {
        this.companyname = companyname == null ? null : companyname.trim();
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address == null ? null : address.trim();
    }

    public String getLicencenum() {
        return licencenum;
    }

    public void setLicencenum(String licencenum) {
        this.licencenum = licencenum == null ? null : licencenum.trim();
    }

    public String getLegalname() {
        return legalname;
    }

    public void setLegalname(String legalname) {
        this.legalname = legalname == null ? null : legalname.trim();
    }

    public String getLegalsex() {
        return legalsex;
    }

    public void setLegalsex(String legalsex) {
        this.legalsex = legalsex == null ? null : legalsex.trim();
    }

    public Date getOfficetime() {
        return officetime;
    }

    public void setOfficetime(Date officetime) {
        this.officetime = officetime;
    }

    public String getLegalcardtype() {
        return legalcardtype;
    }

    public void setLegalcardtype(String legalcardtype) {
        this.legalcardtype = legalcardtype == null ? null : legalcardtype.trim();
    }

    public String getLegalcardnumber() {
        return legalcardnumber;
    }

    public void setLegalcardnumber(String legalcardnumber) {
        this.legalcardnumber = legalcardnumber == null ? null : legalcardnumber.trim();
    }

    public String getNdlegalname() {
        return ndlegalname;
    }

    public void setNdlegalname(String ndlegalname) {
        this.ndlegalname = ndlegalname == null ? null : ndlegalname.trim();
    }

    public String getNdlegalsex() {
        return ndlegalsex;
    }

    public void setNdlegalsex(String ndlegalsex) {
        this.ndlegalsex = ndlegalsex == null ? null : ndlegalsex.trim();
    }

    public Date getNdlegalbrith() {
        return ndlegalbrith;
    }

    public void setNdlegalbrith(Date ndlegalbrith) {
        this.ndlegalbrith = ndlegalbrith;
    }

    public String getNdlegalculture() {
        return ndlegalculture;
    }

    public void setNdlegalculture(String ndlegalculture) {
        this.ndlegalculture = ndlegalculture == null ? null : ndlegalculture.trim();
    }

    public String getNdlegalcardtype() {
        return ndlegalcardtype;
    }

    public void setNdlegalcardtype(String ndlegalcardtype) {
        this.ndlegalcardtype = ndlegalcardtype == null ? null : ndlegalcardtype.trim();
    }

    public String getNdlegalcardnum() {
        return ndlegalcardnum;
    }

    public void setNdlegalcardnum(String ndlegalcardnum) {
        this.ndlegalcardnum = ndlegalcardnum == null ? null : ndlegalcardnum.trim();
    }

    public String getNdlegalnationality() {
        return ndlegalnationality;
    }

    public void setNdlegalnationality(String ndlegalnationality) {
        this.ndlegalnationality = ndlegalnationality == null ? null : ndlegalnationality.trim();
    }

    public String getNdlegalphone() {
        return ndlegalphone;
    }

    public void setNdlegalphone(String ndlegalphone) {
        this.ndlegalphone = ndlegalphone == null ? null : ndlegalphone.trim();
    }

    public String getNdlegaladdress() {
        return ndlegaladdress;
    }

    public void setNdlegaladdress(String ndlegaladdress) {
        this.ndlegaladdress = ndlegaladdress == null ? null : ndlegaladdress.trim();
    }

    public String getNdleaglsjaddress() {
        return ndleaglsjaddress;
    }

    public void setNdleaglsjaddress(String ndleaglsjaddress) {
        this.ndleaglsjaddress = ndleaglsjaddress == null ? null : ndleaglsjaddress.trim();
    }

    public Long getUserid() {
        return userid;
    }

    public void setUserid(Long userid) {
        this.userid = userid;
    }

    public String getApprovalstate() {
        return approvalstate;
    }

    public void setApprovalstate(String approvalstate) {
        this.approvalstate = approvalstate == null ? null : approvalstate.trim();
    }

    public String getApprovalperson() {
        return approvalperson;
    }

    public void setApprovalperson(String approvalperson) {
        this.approvalperson = approvalperson == null ? null : approvalperson.trim();
    }

    public String getApprovalreason() {
        return approvalreason;
    }

    public void setApprovalreason(String approvalreason) {
        this.approvalreason = approvalreason == null ? null : approvalreason.trim();
    }

    public Date getApprovaldate() {
        return approvaldate;
    }

    public void setApprovaldate(Date approvaldate) {
        this.approvaldate = approvaldate;
    }

	public String getTemplateRar() {
		return templateRar;
	}

	public void setTemplateRar(String templateRar) {
		this.templateRar = templateRar;
	}

	public Long getOrgid() {
		return orgid;
	}

	public void setOrgid(Long orgid) {
		this.orgid = orgid;
	}

    public Long getPoliceid() {
        return policeid;
    }

    public void setPoliceid(Long policeid) {
        this.policeid = policeid;
    }

    public String getOldsecurityScopes() {
        return oldsecurityScopes;
    }

    public void setOldsecurityScopes(String oldsecurityScopes) {
        this.oldsecurityScopes = oldsecurityScopes;
    }

    public String getOldcompanyname() {
        return oldcompanyname;
    }

    public void setOldcompanyname(String oldcompanyname) {
        this.oldcompanyname = oldcompanyname;
    }

    public String getOldaddress() {
        return oldaddress;
    }

    public void setOldaddress(String oldaddress) {
        this.oldaddress = oldaddress;
    }

    public String getOldregisteredMoney() {
        return oldregisteredMoney;
    }

    public void setOldregisteredMoney(String oldregisteredMoney) {
        this.oldregisteredMoney = oldregisteredMoney;
    }

    public Long getCompanyid() {
        return companyid;
    }

    public void setCompanyid(Long companyid) {
        this.companyid = companyid;
    }

    public Approval getApproval() {
        return approval;
    }

    public void setApproval(Approval approval) {
        this.approval = approval;
    }

    public String getChangeProject() {
        return changeProject;
    }

    public void setChangeProject(String changeProject) {
        this.changeProject = changeProject;
    }
}