package com.bcxin.ars.dto.export;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.bcxin.ars.enums.SignType;
import lombok.Data;

import java.util.Date;

/**
 * @author linqinglin
 * @date 2020/05/26 0026 14:34
 */
@Data
public class GradeSubsidyRosterExportDto {



    /**
     * 是否在批次审批中
     */
    @ModelAnnotation(column ="used",getName = "是否在批次审批中")
    private Boolean used;

    /**
     * 状态
     */
    @ModelAnnotation(column ="subsidyStatus",getName = "状态",needTranslate=true,dictName = "compareStatus",isExport = true)
    private String subsidyStatus;
    /**
     * 姓名
     */
    @ModelAnnotation(column ="name",getName = "姓名",isExport = true,sign= SignType.LIKE)
    private String name;
    /**
     * 身份证号
     */
    @ModelAnnotation(column ="idNum",getName = "身份证号",isExport = true,sign= SignType.LIKE)
    private String idNum;
    /**
     * 手机号
     */
    @ModelAnnotation(column ="phone",getName = "手机号",isExport = true,sign= SignType.LIKE)
    private String phone;
    /**
     * 性别
     */
    @ModelAnnotation(column ="sex",getName = "性别",needTranslate=true,dictName = "sex",isExport = true)
    private String sex;

    /**
     * 报名id
     */
    private Long gradeId;

    /**
     * 公安机关id
     */
    private Long orgId;
    /**
     * 公安机关名称
     */
    private String orgName;
    /**
     * 培训机构id
     *
     */
    @ModelAnnotation(column ="trainId",getName = "培训机构id")
    private Long trainId;
    /**
     * 培训机构(补贴对象名称)
     *
     */
    @ModelAnnotation(column ="trainName",getName = "补贴对象名称",isExport = true,sign= SignType.LIKE)
    private String trainName;
    /**
     * 公司id
     */
    private Long companyId;
    /**
     * 公司名称
     */
    private String companyName;
    /**
     * 户籍性质
     */
    @ModelAnnotation(column ="residentNature",getName = "户籍性质",needTranslate=true,dictName = "residentType",isExport = true)
    private String residentNature;
    /**
     * 户籍所在地
     */
    @ModelAnnotation(column ="residentPlace",getName = "户籍所在地",needTranslate=true,dictName = "residentPlaceType",isExport = true)
    private String residentPlace;
    /**
     * 劳动合同起始时间
     */
    @ModelAnnotation(column ="contractStartTime",getName = "劳动合同起始时间",isExport = true,DATE_FORMAT= "%Y-%m-%d")
    private Date contractStartTime;
    /**
     * 劳动合同结束时间
     */
    @ModelAnnotation(column ="contractEndTime",getName = "劳动合同结束时间",isExport = true,DATE_FORMAT= "%Y-%m-%d")
    private Date contractEndTime;
    /**
     * 补贴政策类型
     */
    @ModelAnnotation(column ="subsidyType",getName = "补贴政策类型",isExport = true)
    private String subsidyType;
    /**
     * 补贴对象类型（企业、培训机构）
     */
    @ModelAnnotation(column ="subsidyPeopleType",getName = "补贴对象类型",isExport = true)
    private String subsidyPeopleType;
    /**
     * 统一社会信用代码
     */
    @ModelAnnotation(column ="socialCode",getName = "统一社会信用代码",isExport = true)
    private String socialCode;
    /**
     * 培训职业（工种）或项目
     */
    @ModelAnnotation(column ="trainProfession",getName = "培训职业",isExport = true)
    private String trainProfession;
    /**
     * 培训等级（一级、二级、三级、四级、五级、非等级）
     */
    @ModelAnnotation(column ="trainGrade",getName = "培训等级",isExport = true)
    private String trainGrade;
    /**
     *  培训课时
     */
    @ModelAnnotation(column ="classHour",getName = "培训课时",isExport = true)
    private String classHour;
    /**
     * 培训开始时间
     */
    @ModelAnnotation(column ="trainBeginDate",getName = "培训开始时间",isExport = true,DATE_FORMAT= "%Y-%m-%d")
    private Date trainBeginDate;
    /**
     * 培训结束时间
     */
    @ModelAnnotation(column ="trainEndDate",getName = "培训结束时间",isExport = true,DATE_FORMAT= "%Y-%m-%d")
    private Date trainEndDate;
    /**
     *  补贴金额
     */
    @ModelAnnotation(column ="subsidyMoney",getName = "补贴金额",isExport = true)
    private String subsidyMoney;
    /**
     *  补贴金额比例
     */
    @ModelAnnotation(column ="subsidyMoneyRate",getName = "可补贴金额比例",isExport = true)
    private String subsidyMoneyRate;
    /**
     *证书类型
     */
    @ModelAnnotation(column ="certificateType",getName = "证书类型",isExport = true)
    private String certificateType;
    /**
     * 证书编号
     */
    @ModelAnnotation(column ="certificateNumber",getName = "证书编号",isExport = true)
    private String certificateNumber;
    /**
     * 发证时间
     */
    @ModelAnnotation(column ="certificateDate",getName = "发证时间",isExport = true)
    private String certificateDate;
    /**
     * 证书职业工种
     */
    @ModelAnnotation(column ="certificateProfession",getName = "证书职业工种",isExport = true)
    private String certificateProfession;
    /**
     * 证书等级（一级、二级、三级、四级、五级、非等级）
     */
    @ModelAnnotation(column ="certificateGrade",getName = "证书等级",isExport = true)
    private String certificateGrade;
    /**
     *  结业补贴金额
     */
    private String completeMoney;
    /**
     *  结业补贴金额比例
     */
    private String completeMoneyRate;
    /**
     *  鉴定补贴金额
     */
    private String appraisalMoney;
    /**
     *  鉴定补贴金额比例
     */
    private String appraisalMoneyRate;
    /**
     * 备注
     */
    @ModelAnnotation(column ="remark",getName = "备注",isExport = true)
    private String remark;
    /**
     *  原因
     */
    @ModelAnnotation(column ="reason",getName = "不可申请原因",isExport = true)
    private String reason;

    /**
     * 结业证书编号
     *
     */
    private String completeCerNo;

    /**
     * 结业发证日期
     *
     */
    private String completeCerDate;

    /**
     * 鉴定发证日期
     *
     */
    private String cerDate;
    /**
     * 鉴定证书编号
     *
     */
    private String cerNo;

    /**
     * 补贴证书类型
     */
    @ModelAnnotation(column ="subsidyCerType",getName = "补贴证书类型")
    private String subsidyCerType;
}
