package com.bcxin.ars.dto.export;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.bcxin.ars.enums.SignType;
import lombok.Data;

import java.util.Date;

/***
 * 疫情防控导出
 * @author subh
 */
@Data
public class EpidemicExportDto {
    @ModelAnnotation(getName="公司名称",isExport = true,column  = "companyName",sign= SignType.LIKE)
    private String companyName;
    @ModelAnnotation(getName="驻勤点名称",isExport = true,column  = "taskName",sign= SignType.LIKE)
    private String taskName ;
    @ModelAnnotation(getName="开始人数",column  = "perNum",sign= SignType.GREATER_EQUAL)
    private String startPerNum;
    @ModelAnnotation(getName="结束人数",column  = "perNum",sign= SignType.LESS_EQUAL)
    private String endPerNum;
    @ModelAnnotation(getName="填报开始时间",column  = "filledByTime",sign= SignType.DATE_GREATER_EQUAL)
    private String startFilledByTime;
    @ModelAnnotation(getName="填报结束时间",column  = "filledByTime",sign= SignType.DATE_LESS_EQUAL)
    private String endFilledByTime;
    @ModelAnnotation(getName="填表人",isExport = true,column  = "filledBy")
    private String filledBy;
    @ModelAnnotation(getName="填报人电话",isExport = true,column  = "filledByPhone")
    private String filledByPhone;
    @ModelAnnotation(getName="填报时间",isExport = true,column  = "filledByTime")
    private Date filledByTime;
    @ModelAnnotation(getName="驻勤点ID",column  = "taskId")
    private Long taskId;
    @ModelAnnotation(getName="驻勤点详细地址",isExport = true,column  = "taskAddress")
    private String taskAddress;
    @ModelAnnotation(getName="监管机构",column  = "orgName",isExport = true)
    private String orgName;
    @ModelAnnotation(getName="监管机构ID",column  = "orgId")
    private Long orgId;
    @ModelAnnotation(getName="所属区域",column  = "areaCode",sign = SignType.LIKE_AREACODE)
    private String areaCode;
    @ModelAnnotation(getName="保安员总人数",isExport = true,column  = "perNum",isGrid = true,width = "100px")
    private Long perNum;
    @ModelAnnotation(getName="已做核酸人数",isExport = true,column  = "nucleicCheckNum",isGrid = true,width = "100px")
    private Long nucleicCheckNum;
    @ModelAnnotation(getName="已做核酸未出结果人数",isExport = true,column  = "nucleicNum",isGrid = true,width = "150px")
    private Long nucleicNum;
    @ModelAnnotation(getName="未做核酸检测人数",isExport = true,column  = "unNucleicNum",isGrid = true,width = "150px")
    private Long unNucleicNum;
    @ModelAnnotation(getName="核酸检测呈阳性人数",isExport = true,column  = "nucleicPositiveNum",isGrid = true,width = "150px")
    private Long nucleicPositiveNum;
    @ModelAnnotation(getName="确诊人数",isExport = true,column  = "diagnosisNum",isGrid = true,width = "100px")
    private Long diagnosisNum;
    @ModelAnnotation(getName="政府集中隔离人数",isExport = true,column  = "quarantineGovNum",isGrid = true,width = "150px")
    private Long quarantineGovNum;
    @ModelAnnotation(getName="公司集中隔离人数",isExport = true,column  = "quarantineComNum",isGrid = true,width = "150px")
    private Long quarantineComNum;
    @ModelAnnotation(getName="驻勤点原地隔离人数",isExport = true,column  = "quarantineTaskNum",isGrid = true,width = "150px")
    private Long quarantineTaskNum;
    @ModelAnnotation(getName="隔离总人数",isExport = true,column  = "quarantineNum",isGrid = true,width = "100px")
    private Long quarantineNum;
    @ModelAnnotation(getName="核酸检测点",isExport = true,column  = "checkHospital",isGrid = false,needTranslate = true,dictName ="checkHospital",width = "100px" )
    private String checkHospital;
    @ModelAnnotation(getName="公司userID",column  = "userId",sign= SignType.EQUAL_AND_NULL)
    private Long userId;
    @ModelAnnotation(getName="驻勤点类型",isExport = true,column  = "epidemicTaskType",isGrid = false,needTranslate = true,dictName ="epidemicTaskType",width = "100px" )
    private String epidemicTaskType;
    @ModelAnnotation(getName="临时检测点名称",isExport = true,column  = "tempCheckHospital")
    private String tempCheckHospital;
    @ModelAnnotation(getName="所在街道",isExport = true,column  = "streetName",sign= SignType.LIKE)
    private String streetName;
    @ModelAnnotation(getName="风险级别",isExport = true,column  = "riskLevel",sign= SignType.EQUAL_AND_NULL,needTranslate = true,dictName ="riskLevel")
    private String riskLevel;
}
