package com.bcxin.ars.dto.export;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.bcxin.ars.enums.SignType;
import com.bcxin.ars.model.BaseModel;
import com.bcxin.ars.model.sys.Approval;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * @author：huangzp
 * @date：2018/04/09
 * @description：自招撤销备案实体 sb_confesscompanyundo
 */
@Data
public class ConfesscompanyundoExportDTO extends BaseModel {

    public ConfesscompanyundoExportDTO() { }

    //单位名称
    @ModelAnnotation(getName="单位名称",isExport = true,column  = "companyname",defaultColumn = true)
    private String companyname;
    /**
     * 提交时间（审批表）
     */
    @ModelAnnotation(getName="提交时间",column = "create_time",isExport = true,defaultColumn=true,anotherTable=true)
    private Date createTime;
    //备案登录号
    @ModelAnnotation(getName="备案登录号",isExport = true,column  = "loginnum")
    private String loginnum;
    //申请撤销备案日期
    @ModelAnnotation(getName="申请撤销备案日期",isExport = true,column  = "canceldate")
    private Date canceldate;
    //申请撤销备案日期
    private String canceldatestr;
    //备案日期
    @ModelAnnotation(getName="备案日期",isExport = true,column  = "badate")
    private Date badate;


    //备案日期
    private String badatestr;
    //撤销原因
    @ModelAnnotation(getName="撤销原因",isExport = true,column  = "cancelreson")
    private String cancelreson;
    //单位地址
    @ModelAnnotation(getName="单位地址",isExport = true,column  = "address")
    private String address;
    //法人姓名
    @ModelAnnotation(getName="法人姓名",isExport = true,column  = "legalname",defaultColumn = true)
    private String legalname;
    //法人身份证号
    @ModelAnnotation(getName="法人身份证号",isExport = true,column  = "legalcard")
    private String legalcard;
    //法人手机号
    @ModelAnnotation(getName="法人手机号",isExport = true,column  = "legalphone",defaultColumn = true)
    private String legalphone;
    //审批状态
    @ModelAnnotation(getName="审批状态",isExport = true,column  = "approvalstate",defaultColumn = true,needTranslate = true,dictName = "approvalState")
    private String approvalstate;
    //审批人
    /*@ModelAnnotation(getName="审批人",isExport = true,column  = "approvalperson")*/
    private String approvalperson;
    //审批原因
    /*@ModelAnnotation(getName="审批原因",isExport = true,column  = "approvalreason")*/
    private String approvalreason;
    //审批时间
    /*@ModelAnnotation(getName="审批时间",isExport = true,column  = "approvaldate")*/
    private Date approvaldate;
    //所在地省代码
    @ModelAnnotation(getName="所在地省代码",isExport = true,column  = "province")
    private String province;
    //所在地市代码
    @ModelAnnotation(getName="所在地市代码",isExport = true,column  = "city")
    private String city;
    //所在地县（区）代码
    @ModelAnnotation(getName="所在区市代码",isExport = true,column  = "district",sign = SignType.LIKE)
    private String district;
    //派出所ID
    @ModelAnnotation(getName="派出所ID",isExport = true,column  = "orgid")
    private Long orgid;
    //撤销申请书附件
    @ModelAnnotation(getName="撤销申请书附件",isExport = true,column  = "cancelapplyfj")
    private String cancelapplyfj;
    //单位法人资格证明材料
    @ModelAnnotation(getName="单位法人资格证明材料",isExport = true,column  = "legalzmcl")
    private String legalzmcl;
    //法人身份证正面
    @ModelAnnotation(getName="法人身份证正面",isExport = true,column  = "legalcardpicz")
    private String legalcardpicz;
    //法人身份证反面
    @ModelAnnotation(getName="法人身份证反面",isExport = true,column  = "legalcardpicf")
    private String legalcardpicf;
    //办事区域
    @ModelAnnotation(getName="办事区域",isExport = true,column  = "szss")
    private String szss;
    //项目服务区域
    @ModelAnnotation(getName="项目服务区域",isExport = true,column  = "servicearea")
    private String servicearea;
    //审查状态
    @ModelAnnotation(getName="审查状态",isExport = true,column  = "censor_status",needTranslate = true,dictName = "censorStatus")
    private String censorstatus;
    //流程实例id
    private String processInstanceId;

    /**
     * 审批信息列表
     */
    private List approvallist;

    /**
     * 审批信息列表
     */
    private Approval approval;

    /**
     * 备案单路径
     */
  private String confirmpath;
    /**
     * 登记证路径
     */
    private String registerpath;


}
