package com.bcxin.ars.dto.export;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.abcxin.smart.validator.annotation.ModelTableAnnotation;
import com.bcxin.ars.enums.SignType;
import lombok.Data;

import java.util.Date;

/**
 * @author linqinglin
 * @date 2020/03/12 0012 13:58
 */
@Data
@ModelTableAnnotation(extra = false,tableName = "v_com_task")
public class ComTaskExportDto {

    @ModelAnnotation(getName="驻勤名称",column = "taskName",isExport = true,sign= SignType.LIKE)
    private String taskName;

    @ModelAnnotation(getName="驻勤点类型",column = "taskStationType",isExport = true,needTranslate = true,dictName = "taskStationType")
    private String taskStationType;

    @ModelAnnotation(getName="保安公司",column = "comName",isExport = true,sign= SignType.LIKE)
    private String comName;

    @ModelAnnotation(getName="服务企业",column = "serviceObject",isExport = true,sign= SignType.LIKE)
    private String serviceObject;

    @ModelAnnotation(getName="服务企业类型",column = "serviceObjectSySituation",isExport = true,needTranslate = true,dictName = "serviceObjectSySituation")
    private String serviceObjectSySituation;

    @ModelAnnotation(getName="驻勤地址",column = "taskAddress",isExport = true,sign= SignType.LIKE)
    private String taskAddress;

    @ModelAnnotation(getName="监管机构",column = "orgName",isExport = true)
    private String orgName;

    @ModelAnnotation(getName="合同名称",column = "contractName",isExport = true)
    private String contractName;

    @ModelAnnotation(getName="合同状态",column = "contractStatus",isExport = true,needTranslate = true,dictName = "contractStatusNew")
    private String contractStatus;

    @ModelAnnotation(getName="驻勤状态",column = "taskStatusNew",isExport = true,needTranslate = true,dictName = "taskStatusNew")
    private String taskStatusNew;

    @ModelAnnotation(getName="合同开始日期",column = "startDate",isExport = true,sign= SignType.DATE_GREATER_EQUAL)
    private String startDate;

    @ModelAnnotation(getName="合同终止日期",column = "endDate",isExport = true,sign= SignType.DATE_LESS_EQUAL)
    private String endDate;

    @ModelAnnotation(getName="驻勤开始日期",column = "taskStartDate",isExport = true,sign= SignType.TASK_DATE_GREATER_EQUAL)
    private Date taskStartDate;

    @ModelAnnotation(getName="驻勤终止日期",column = "taskEndDate",isExport = true,sign= SignType.TASK_DATE_LESS_EQUAL)
    private Date taskEndDate;

    @ModelAnnotation(getName="保安人数",column = "perNum",isExport = true)
    private Long perNum;

    @ModelAnnotation(getName="数据区域",column = "comAreaCode,taskAreaCode",sign= SignType.OR_LIKE)
    private String areaCode;

    @ModelAnnotation(getName="数据区域",column = "comAreaCode",sign= SignType.LIKE_AREACODE)
    private String comAreaCode;

    @ModelAnnotation(getName="数据区域",column = "taskAreaCode",sign= SignType.LIKE_AREACODE)
    private String taskAreaCode;

    @ModelAnnotation(getName="监管机构id",column = "comOrgId,taskOrgId",sign= SignType.OR)
    private String orgId;

    @ModelAnnotation(getName="公司监管机构id",column = "comOrgId")
    private String orgIdCom;

    @ModelAnnotation(getName="驻勤点监管机构id",column = "taskOrgId")
    private String orgIdTask;

}
