package com.bcxin.ars.dto.export;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.abcxin.smart.validator.annotation.ModelTableAnnotation;
import com.bcxin.ars.enums.SignType;
import lombok.Data;

import java.util.Date;

/**
 * @author linqinglin
 * @date 2020/01/14 0014 10:36
 */
@Data
@ModelTableAnnotation(extra = false)
public class ComContractExportDTO {

    /** 合同类型 */
    @ModelAnnotation(getName="合同类型",column = "contractType",isExport = true,needTranslate = true,dictName = "contractType")
    private String contractType;

    /** 合同状态 */
    @ModelAnnotation(getName="合同状态",column = "contractStatus",isExport = true,needTranslate = true,dictName = "contractStatus",sign = SignType.CASE)
    private String contractStatus;

    /** 合同名称 */
    @ModelAnnotation(getName="合同名称",column = "contractName",isExport = true,sign= SignType.LIKE)
    private String contractName;

    /** 企业档案编号 */
    @ModelAnnotation(getName="企业档案编号",column = "comFileNo",isExport = true,sign= SignType.LIKE)
    private String comFileNo;

    /** 企业所在方 */
    private String comParty;

    /** 甲方名称 */
    @ModelAnnotation(getName="甲方名称",column = "firstPartyName",isExport = true,sign= SignType.LIKE)
    private String firstPartyName;

    /** 甲方联系电话 */
    @ModelAnnotation(getName="甲方联系电话",column = "firstPartyTel",isExport = true,sign= SignType.LIKE)
    private String firstPartyTel;

    /** 乙方名称 */
    @ModelAnnotation(getName="乙方名称",column = "secondPartyName",isExport = true,sign= SignType.LIKE)
    private String secondPartyName;

    /** 乙方联系电话 */
    @ModelAnnotation(getName="乙方联系电话",column = "secondPartyTel",isExport = true,sign= SignType.LIKE)
    private String secondPartyTel;

    /** 生效开始日期 */
    @ModelAnnotation(getName="生效开始日期",column = "effectStartDate",isExport = true,sign= SignType.DATE_GREATER_EQUAL)
    private Date effectStartDate;

    /** 生效终止日期 */
    @ModelAnnotation(getName="生效终止日期",column = "effectEndDate",isExport = true,sign= SignType.DATE_LESS_EQUAL)
    private Date effectEndDate;

    /** 合同期限 */
    @ModelAnnotation(getName="合同期限",column = "contractPeriod",isExport = true)
    private String contractPeriod;

    /** 协议签订日期 */
    @ModelAnnotation(getName="协议签订日期",column = "agreementSignDate",isExport = true)
    private Date agreementSignDate;

    /** 合同文件url */
    private String contractUrl;

    /** 备注 */
    @ModelAnnotation(getName="备注",column = "remark",isExport = true)
    private String remark;

    /*驻勤点*/
    @ModelAnnotation(getName="驻勤点",column = "taskName",isExport = true,sign= SignType.LIKE)
    private String taskName;
    /**
     * 是否关联驻勤点
     */
    @ModelAnnotation(getName="是否关联驻勤点",column = "taskName",sign= SignType.IS_HAVE_TASk)
    private String isHaveTask;
}
