package com.bcxin.ars.dto.exam;

import java.io.Serializable;

import com.bcxin.ars.dto.SearchDto;

/**
 * 考试基本信息DTO
 * 
 * @author zhangye
 * @version 1.0
 */
public class TrainExamInfoSearchDto extends SearchDto<TrainExamInfoDto> implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = -7465268346330230930L;

	/**
	 * 考点名称
	 */
	private String examName;

	/**
	 * 是否补考
	 */
	private String isMakeUp;

	public String getIsMakeUp() {
		return isMakeUp;
	}

	public void setIsMakeUp(String isMakeUp) {
		this.isMakeUp = isMakeUp;
	}

	/**
	 * 科目ID
	 */
	private Long subjectID;

	/**
	 * 第几页数(分页插件参数)
	 */
	protected Integer offset;
	/**
	 * 每页显示几条(分页插件参数)
	 */
	protected Integer limit;

	/**
	 * 行政区划编码
	 */
	private String areaCode;

	public String getExamName() {
		return examName;
	}

	public void setExamName(String examName) {
		this.examName = examName;
	}

	public Long getSubjectID() {
		return subjectID;
	}

	public void setSubjectID(Long subjectID) {
		this.subjectID = subjectID;
	}

	public Integer getOffset() {
		return offset;
	}

	public void setOffset(Integer offset) {
		this.offset = offset;
	}

	public Integer getLimit() {
		return limit;
	}

	public void setLimit(Integer limit) {
		this.limit = limit;
	}

	public String getAreaCode() {
		return areaCode;
	}

	public void setAreaCode(String areaCode) {
		this.areaCode = areaCode;
	}

}