package com.bcxin.ars.dto.approve;

import lombok.Data;

import java.util.Date;

/**
 * @author：wangcy @date：2018/01/17 0017 9:35
 * @description：审批模板Dto
 */
@Data
public class ApproveTempDto {
    /**
     * 审批组Id
     */
    private Long approveGroupId;
    /**
     * 审批组名称
     */
    private String groupName;

	/**
	 * 机构名称
	 */
	private String orgName;

	/**
	 * 审批模板最后一次修改时间
	 */
	private Date updateTime;
	/**
	 * 审批模板Id
	 */
	private String tempId;
	/**
	 * 审批模板编码
	 */
	private String tempCode;

	/**
	 * 审批模板名称
	 */
	private String tempName;
	/**
	 * 审批模板图标
	 */
	private String iconUrl;
	/**
	 * 各级别审批配置状态(0:待配置,1:已启动)
	 */
	private String approveSetStatus;
	/**
	 * 审批组顺序
	 */
	private Integer groupSeq;
	/**
	 * 审批模板顺序
	 */
	private Integer tempSeq;
	/**
	 * 公安单位Id
	 */
	private Long policeId;

	/**
	 * 父公安单位Id
	 */
	private Long parentPoliceId;

	/**
	 * 父模板Id
	 */
	private Long parentTempId;

	/**
	 * 审批类型
	 */
	private String approveType;
}
