package com.bcxin.ars.dto.appraise;

import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import lombok.Data;

import java.util.ArrayList;
import java.util.List;

/**
 * @author linqinglin
 * @date 2020/10/15 0015 13:45
 */
@Data
public class AppraisePageResultDto {

    private Integer pageNumber ;// 当前页属于第几页

    private Integer pageNo ;// 当前页属于第几页

    private Integer pageSize ;// 每页数据条数44 / 74
    private Long totalCount ;// 数据总条数
    private Long totalPages ;// 总页数
    private Integer nextPage ;// 下一页为第几页
    private Boolean hasNext ;// 是否有下一页
    private Boolean hasPre ;// 是否有前一页
    private Integer prePage ;// 前一页为第几页
    private Integer last ;// 当前最后一条为第几条
    private Integer first ;// 当前第一条为第几条
    private Boolean pageDown ;// 是否有翻页,默认为 true
    private List result = new ArrayList<>();//整改反馈列表

    public AjaxPageResponse toAjaxPage() {
        AjaxPageResponse page = new AjaxPageResponse();
        if(this.getPageNo() != null) {
            page.setPageNumber(this.getPageNo());
        }
        if(this.getPageSize() != null) {
            page.setPageSize(this.getPageSize());
        }
        if(this.getTotalCount() != null) {
            page.setTotal(this.getTotalCount());
        }
        if(this.getResult() != null) {
            page.setData(this.getResult());
        }
        return page;
    }

    public Integer getPageNo() {
        if(pageNo == null) {
            return pageNumber;
        }
        return pageNo;
    }
}
