package com.bcxin.ars.dto;

import org.springframework.util.StringUtils;

import com.bcxin.ars.model.SecurityPerson;

/**
 * 保安员搜索参数
 * @author Ethan
 */
public class PersonSearchDto extends SearchDto<SecurityPerson> {
	
	private Long companyId;

	private String professionLevel;

	private String edu;
	
	private String[] levels;
	
	private String age;

	private String ageStart;

	private String ageEnd;

	private String problemtype;

	private String gender;
	
	private String[] genders;
	
	private Long nativeCode;

	private String nativePlace;
	
	private String realname;

	private String companyname;
	
    private String phone;
    
    private String idNumber;//身份证号

	private String orgIds;//组织结构（可多个用,隔开）

	private String[] orgIdList;
	
	private String[] edus;
	
	private Integer starLevel;
	
	private String[] qualifieds;
	
	private String[] insureds;
	
	private String stature;
	
	private String exp;

	private String areaCode;

	public String getAreaCode() {
		return areaCode;
	}

	public void setAreaCode(String areaCode) {
		this.areaCode = areaCode;
	}

	private String minLat ;
	private String maxLat ;
	/*位置经度区间*/
	private String minLng ;
	private String maxLng ;


	private String insured;
	private boolean online;

	private boolean urgenttemp;


	/***
	 * 状态
	 */
	private String incumbencyStatus;

	private String init;

	private String identityAuthState;


	public String getIncumbencyStatus() {
		return incumbencyStatus;
	}

	public void setIncumbencyStatus(String incumbencyStatus) {
		this.incumbencyStatus = incumbencyStatus;
	}

	public String getInsured() {
		return insured;
	}

	public void setInsured(String insured) {
		this.insured = insured;
	}

	public boolean isOnline() {
		return online;
	}

	public void setOnline(boolean online) {
		this.online = online;
	}

	public boolean isUrgenttemp() {
		return urgenttemp;
	}

	public void setUrgenttemp(boolean urgenttemp) {
		this.urgenttemp = urgenttemp;
	}

	public String getMinLat() {
		return minLat;
	}

	public void setMinLat(String minLat) {
		this.minLat = minLat;
	}

	public String getMaxLat() {
		return maxLat;
	}

	public void setMaxLat(String maxLat) {
		this.maxLat = maxLat;
	}

	public String getMinLng() {
		return minLng;
	}

	public void setMinLng(String minLng) {
		this.minLng = minLng;
	}

	public String getMaxLng() {
		return maxLng;
	}

	public void setMaxLng(String maxLng) {
		this.maxLng = maxLng;
	}

	public Long getCompanyId() {
		return companyId;
	}

	public void setCompanyId(Long companyId) {
		this.companyId = companyId;
	}
	
	public String getProfessionLevel() {
		return professionLevel;
	}

	public void setProfessionLevel(String professionLevel) {
		this.professionLevel = professionLevel;
	}

	public String getAge() {
		return age;
	}

	public void setAge(String age) {
		if(age.indexOf("-") > 0) {
			this.age = age.replaceAll("-", " AND age < ");
		}else if(age.indexOf(",") > 0) {
			if(!age.split(",")[0].equals(age.split(",")[1])){
				this.age = age.replaceAll(",", " AND age < ");
			}
		}
	}

	public String getGender() {
		return gender;
	}

	public void setGender(String gender) {
		this.gender = gender;
	}

	public Long getNativeCode() {
		return nativeCode;
	}

	public void setNativeCode(Long nativeCode) {
		this.nativeCode = nativeCode;
	}

	public String getNativePlace() {
		return nativePlace;
	}

	public void setNativePlace(String nativePlace) {
		this.nativePlace = nativePlace;
	}

	public String getRealname() {
		return realname;
	}

	public void setRealname(String realname) {
		this.realname = realname;
	}

	public String getPhone() {
		return phone;
	}

	public void setPhone(String phone) {
		this.phone = phone;
	}

	public String getIdNumber() {
		return idNumber;
	}

	public void setIdNumber(String idNumber) {
		this.idNumber = idNumber;
	}

	public String getOrgIds() {
		return orgIds;
	}

	public void setOrgIds(String orgIds) {
		this.orgIds = orgIds;
	}

	public String[] getOrgIdList() {
		String[] orgs = null;
		if(orgIdList == null || orgIdList.length<1){
			if(!StringUtils.isEmpty(orgIds)){
				orgs = orgIds.split(",");
			}
		}else{
			orgs = orgIdList;
		}
		return orgs;
	}

	public void setOrgIdList(String[] orgIdList) {
		this.orgIdList = orgIdList;
	}


	public Integer getStarLevel() {
		return starLevel;
	}

	public void setStarLevel(Integer starLevel) {
		this.starLevel = starLevel;
	}

	public String getStature() {
		return stature;
	}

	public void setStature(String stature) {
		if(stature.indexOf("-") > 0) {
			this.stature = stature.replaceAll("-", " AND stature < ");
		}else if(stature.indexOf(",") > 0) {
			if(!stature.split(",")[0].equals(stature.split(",")[1])){
				this.stature = stature.replaceAll(",", " AND stature < ");
			}
		}
	}

	public String getExp() {
		return exp;
	}

	public void setExp(String exp) {
		if(exp.indexOf("-") > 0) {
			this.exp = exp.replaceAll("-", " AND (exp/12) < ");
		}else if(exp.indexOf(",") > 0) {
			if(!exp.split(",")[0].equals(exp.split(",")[1])){
				this.exp = exp.replaceAll(",", " AND (exp/12) < ");
			}
		}
	}

	public String[] getLevels() {
		return levels;
	}

	public void setLevels(String[] levels) {
		this.levels = levels;
	}

	public String[] getGenders() {
		return genders;
	}

	public void setGenders(String[] genders) {
		this.genders = genders;
	}

	public String[] getEdus() {
		return edus;
	}

	public void setEdus(String[] edus) {
		this.edus = edus;
	}

	public String[] getQualifieds() {
		return qualifieds;
	}

	public void setQualifieds(String[] qualifieds) {
		this.qualifieds = qualifieds;
	}

	public String[] getInsureds() {
		return insureds;
	}

	public void setInsureds(String[] insureds) {
		this.insureds = insureds;
	}

	public String getCompanyname() {
		return companyname;
	}

	public void setCompanyname(String companyname) {
		this.companyname = companyname;
	}

	public String getInit() {
		return init;
	}

	public void setInit(String init) {
		this.init = init;
	}

	public String getIdentityAuthState() {
		return identityAuthState;
	}

	public void setIdentityAuthState(String identityAuthState) {
		this.identityAuthState = identityAuthState;
	}


	public String getEdu() {
		return edu;
	}

	public void setEdu(String edu) {
		this.edu = edu;
	}

	public String getAgeStart() {
		return ageStart;
	}

	public void setAgeStart(String ageStart) {
		this.ageStart = ageStart;
	}

	public String getAgeEnd() {
		return ageEnd;
	}

	public void setAgeEnd(String ageEnd) {
		this.ageEnd = ageEnd;
	}

	public String getProblemtype() {
		return problemtype;
	}

	public void setProblemtype(String problemtype) {
		this.problemtype = problemtype;
	}
}
