package com.bcxin.ars.dto;

import com.bcxin.ars.serializer.LongJsonDeserializer;
import com.bcxin.ars.serializer.LongJsonSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;

import java.io.Serializable;

/**
 * @author linqinglin
 * @date 2019/11/21 0021 14:41
 */
@Data
public class GradeCertificateToSAASDto implements Serializable {

    private static final long serialVersionUID = 2220082166930076300L;

    /**
     *人员ID
     */

    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long perId;

    /**
     *证书编号
     */
    private String cerNo;

    /**
     *证书等级
     * 01000101	初级保安员
     * 01000102	中级保安员
     * 01000103	高级保安员
     * 01000104	保安师
     * 01000105	高级保安管理员
     */
    private String perCerLevel;

    /**
     *发证日期
     * yyyy-mm-dd
     */
    private String licenceDate;

    /**
     *培训机构名称
     */
    private String trainOrganName;
}
