package com.bcxin.ars.dto;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.abcxin.smart.validator.annotation.ModelTableAnnotation;
import com.bcxin.ars.enums.SignType;
import lombok.Data;

import java.io.Serializable;

/**
 * @author linqinglin
 * @date 2020/07/27 0027 10:00
 */
@Data
@ModelTableAnnotation(getName = "保安智能卡", tableName = "v_person_bank", extra = false)
public class BankAccountExportDto implements Serializable {

    private static final long serialVersionUID = 2220082166930076300L;

    @ModelAnnotation(getName = "id", column = "id", sign = SignType.EQUAL)
    private String id;

    @ModelAnnotation(getName = "姓名", column = "name", isExport = true, sign = SignType.LIKE)
    private String name;

    @ModelAnnotation(getName = "身份证号", column = "idnum", isExport = true, sign = SignType.LIKE)
    private String idnum;

    @ModelAnnotation(getName = "手机号码", column = "phone", isExport = true, sign = SignType.LIKE)
    private String phone;

    @ModelAnnotation(getName = "现职保安公司", column = "companyName", isExport = true, sign = SignType.LIKE)
    private String companyName;

    @ModelAnnotation(getName = "发证编号", column = "cerNo", isExport = true, sign = SignType.LIKE)
    private String cerNo;

    @ModelAnnotation(getName = "发证日期", column = "cerDate", isExport = true, DATE_FORMAT = "%Y-%m-%d")
    private String cerDate;

    @ModelAnnotation(getName = "是否在职", column = "incumbencyStatus", isExport = true, needTranslate = true, dictName = "incumbencyStatus")
    private String incumbencyStatus;

    @ModelAnnotation(getName = "换发日期", column = "bankDate", DATE_FORMAT = "%Y-%m-%d")
    private String bankDate;

    @ModelAnnotation(getName = "发证日期", column = "cerDate", sign = SignType.DATE_GREATER_EQUAL)
    private String cerStartDate;

    @ModelAnnotation(getName = "发证日期", column = "cerDate", sign = SignType.DATE_LESS_EQUAL)
    private String cerEndDate;

    @ModelAnnotation(getName = "发卡日期", column = "activeDate", isExport = true, DATE_FORMAT = "%Y-%m-%d")
    private String activeDate;

    @ModelAnnotation(getName = "发卡日期", column = "activeDate", sign = SignType.DATE_GREATER_EQUAL)
    private String bankStartDate;

    @ModelAnnotation(getName = "发卡日期", column = "activeDate", sign = SignType.DATE_LESS_EQUAL)
    private String bankEndDate;

    @ModelAnnotation(getName = "卡状态", column = "cardState", isExport = true, needTranslate = true, dictName = "bankCardState")
    private String cardState;

    @ModelAnnotation(getName = "注销时间", column = "logoutDate", isExport = true)
    private String logoutDate;

}
