package com.bcxin.ars.dto;

import com.bcxin.ars.model.PoliceRole;
import com.bcxin.ars.model.sb.Subsidiary;
import com.bcxin.ars.model.sb.UserBusinessType;
import com.bcxin.ars.model.sys.Approval;
import com.bcxin.ars.serializer.LongJsonDeserializer;
import com.bcxin.ars.serializer.LongJsonSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import java.util.Date;
import java.util.List;

/**
 * Created by 苏 on 2017/5/1.
 */
public class ApprovalDTO extends SearchDto<Approval> {
    /***
     * 主键
     */
    private Long id;

    /**
     * 对外审批意见
     */
    private String outreason;

    public String getOutreason() {
        return outreason;
    }

    public void setOutreason(String outreason) {
        this.outreason = outreason;
    }

    /**
     * 对外意见附件
     */
    private String outinfoRar;

    public String getOutinfoRar() {
        return outinfoRar;
    }

    public void setOutinfoRar(String outinfoRar) {
        this.outinfoRar = outinfoRar;
    }


    /**
     * 审批内容
     */
    private String context;
    /***
     * 业务类型
     */
    private String businesstype;
    /***
     * 审批状态
     */
    private String approvalstate;
    /***
     * 审批原因
     */
    private String approvalreason;
    /***
     * 子公司信息
     */
    private Subsidiary subsidiary;
    /**
     * 审批机构ID
     */
    private Long orgid;
    /***
     * 业务ID
     */
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long businessid;


    private Long userid;

    private Date startDate;
    
    private Date endDate;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 资料补正告知书
     */
    private String infoRar;

    /**
     * 批复意见
     * @return
     */
    private String replyreason;

    /**
     * 批复附件
     * @return
     */
    private String replyRar;

    /***
     * 批复状态
     */
    private String replystate;
    /**
     * 受理民警id
     */
    private Long policeid;




    private Integer platform;

    /***
     * 区域
     */
    private String areaCode;
    /***
     * 角色ID
     */
    private Long roleid;


    /***
     * 角色列表
     */
    private List<PoliceRole> roles;

    /***
     * 查询类型
     */
    private String searchType;


    /***
     * 考试角色
     */
    private String ksjsid;

    /**
     * 流程结束状态
     */
    private String prostate;

    /**
     * 是否需要流程
     */
    private String isNeedActivity;


    /**
     * 是否需要制证流程
     */
    private String isNeedCardActivity;

    public String getIsNeedCardActivity() {
        return isNeedCardActivity;
    }

    public void setIsNeedCardActivity(String isNeedCardActivity) {
        this.isNeedCardActivity = isNeedCardActivity;
    }

    /**
     * 确认制证状态 1已确认0未确认
     */
    private String confirmOrder;

    public String getConfirmOrder() {
        return confirmOrder;
    }

    public void setConfirmOrder(String confirmOrder) {
        this.confirmOrder = confirmOrder;
    }

    public String getIsNeedActivity() {
        return isNeedActivity;
    }

    public void setIsNeedActivity(String isNeedActivity) {
        this.isNeedActivity = isNeedActivity;
    }

    private String approvalperson;

    public String getApprovalperson() {
        return approvalperson;
    }

    public void setApprovalperson(String approvalperson) {
        this.approvalperson = approvalperson;
    }

    public String getProstate() {
        return prostate;
    }

    public void setProstate(String prostate) {
        this.prostate = prostate;
    }

    public Integer getPlatform() {
        return platform;
    }

    public void setPlatform(Integer platform) {
        this.platform = platform;
    }

    private List<UserBusinessType> userBusinessTypeList ;

    public List<UserBusinessType> getUserBusinessTypeList() {
        return userBusinessTypeList;
    }

    public void setUserBusinessTypeList(List<UserBusinessType> userBusinessTypeList) {
        this.userBusinessTypeList = userBusinessTypeList;
    }

    public String getKsjsid() {
        return ksjsid;
    }

    public void setKsjsid(String ksjsid) {
        this.ksjsid = ksjsid;
    }

    public String getSearchType() {
        return searchType;
    }

    public void setSearchType(String searchType) {
        this.searchType = searchType;
    }

    public List<PoliceRole> getRoles() {
        return roles;
    }

    public void setRoles(List<PoliceRole> roles) {
        this.roles = roles;
    }

    public String getAreaCode() {
        return areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    public Long getRoleid() {
        return roleid;
    }

    public void setRoleid(Long roleid) {
        this.roleid = roleid;
    }

    public String getReplystate() {
        return replystate;
    }

    public void setReplystate(String replystate) {
        this.replystate = replystate;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Long getBusinessid() {
        return businessid;
    }

    public void setBusinessid(Long businessid) {
        this.businessid = businessid;
    }

    public Long getUserid() {
        return userid;
    }

    public void setUserid(Long userid) {
        this.userid = userid;
    }

    public Long getOrgid() {
        return orgid;
    }
    public void setOrgid(Long orgid) {
        this.orgid = orgid;
    }

    public Subsidiary getSubsidiary() {
        return subsidiary;
    }

    public void setSubsidiary(Subsidiary subsidiary) {
        this.subsidiary = subsidiary;
    }

    public String getApprovalreason() {
        return approvalreason;
    }

    public void setApprovalreason(String approvalreason) {
        this.approvalreason = approvalreason;
    }

    public String getContext() {
        return context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public String getBusinesstype() {
        return businesstype;
    }

    public void setBusinesstype(String businesstype) {
        this.businesstype = businesstype;
    }

    public String getApprovalstate() {
        return approvalstate;
    }

    public void setApprovalstate(String approvalstate) {
        this.approvalstate = approvalstate;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

	public Date getStartDate() {
		return startDate;
	}

	public void setStartDate(Date startDate) {
		this.startDate = startDate;
	}

	public Date getEndDate() {
		return endDate;
	}

	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}

	public String getInfoRar() {
		return infoRar;
	}

	public void setInfoRar(String infoRar) {
		this.infoRar = infoRar;
	}

	public String getReplyreason() {
		return replyreason;
	}

	public void setReplyreason(String replyreason) {
		this.replyreason = replyreason;
	}

	public String getReplyRar() {
		return replyRar;
	}

	public void setReplyRar(String replyRar) {
		this.replyRar = replyRar;
	}

	public Long getPoliceid() {
		return policeid;
	}

	public void setPoliceid(Long policeid) {
		this.policeid = policeid;
	}
    
    
}
