package com.bcxin.ars.dto;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dto.appraise.AppraisePageResultDto;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import lombok.Data;

/**
 * @author linqinglin
 * @date 2020/09/25 0025 15:50
 */
@Data
public class AppraiseResultDto {

    private boolean success;

    /**
     * 成功或者失败的code错误码
     * 状态码：-1 系统异常、200 系统正常、 404 请求路径不存在等。
     */
    private String code;

    private Object data;

    /**
     * 请求失败返回的提示信息
     */
    private String errorMessage;

    /**
     * 服务编号
     */
    private String serviceCode;

    /**
     * 服务次数
     */
    private String serviceNumber;

    public static void main(String[] args) {

        String resultStr = "{\"code\":200,\"data\":{\"page\":{\"pageNo\":1,\"pageSize\":10,\"pageDown\":true,\"result\":[{\"id\":\"5f8e8cc878175b588ecb890c\",\"serviceCode\":\"000FW112020102000000038\",\"taskCode\":\"11110000000029030A3000109001000\",\"taskName\":\"保安服务公司设立许可\",\"projectNo\":\"11110000000029030A3000109001000202010200002\",\"proStatus\":\"1\",\"orgcode\":\"11110000000029030A\",\"orgName\":\"昌平公安分局\",\"userProp\":\"1\",\"userName\":\"林庆霖\",\"userPageType\":\"111\",\"certKey\":\"350321198702232290\",\"serviceName\":\"申报\",\"serviceNumber\":1,\"serviceTime\":\"2020-10-20 15:07:52\",\"serviceDate\":\"2020-10-20\",\"dataSource\":\"互联网办事系统\",\"projectType\":1,\"applydate\":\"2020-10-20 15:12:20\",\"bj_zt\":\"12\",\"taskguid\":\"bcf5dac7-76f2-4070-b88e-84ff0d8c89eb\",\"statusUrl\":\"http://114.116.191.105:8010/ars-web//approval/businessDetail.do?approvalId=wwT3FIy2IeIwaMhfznzrHjtkjm2FIIAq\",\"source\":\"SX\",\"sourceTJ\":\"BBAFUJGXXXT\",\"dataly\":\"3\",\"administrative_div\":\"14\",\"telPhone\":\"15750701070\",\"isService\":\"1\",\"realDiv\":\"110114000000\",\"areaCode\":\"110114000000\"}],\"totalCount\":1,\"totalPages\":1,\"hasNext\":false,\"nextPage\":1,\"hasPre\":false,\"prePage\":1,\"last\":1,\"first\":1}},\"success\":true}";

        AppraiseResultDto resultDto = JSONObject.parseObject(resultStr, AppraiseResultDto.class);
        if(resultDto.getData() != null) {
            JSONObject pageJson = JSONObject.parseObject(resultDto.getData().toString());
            AppraisePageResultDto page = JSONObject.parseObject(pageJson.get("page").toString(), AppraisePageResultDto.class);
            AjaxPageResponse ajaxPageResponse = page.toAjaxPage();
            System.out.println(JSON.toJSONString(ajaxPageResponse));
        }
    }
}
