package com.bcxin.ars.dto;

import com.alibaba.fastjson.JSON;
import lombok.Data;

import java.io.Serializable;

@Data
public class AjaxResult implements Serializable {

	private static final long serialVersionUID = 4530474987109938356L;

	private boolean successful;
	private String code;
	private String msg;
	private Object data;
	private Object obj;

	/**
	 * token 用做表单重复提交验证
	 */
	private String token;

	public AjaxResult(){

	}

	public AjaxResult(boolean successful, String msg){
		this.successful = successful;
		this.msg = msg;
		if(successful){
			this.code = "0";
		}else {
			this.code = "9999";
		}
	}

	public AjaxResult(boolean successful, String msg, Object data){
		this.successful = successful;
		this.msg = msg;
		this.data = data;
		if(successful){
			this.code = "0";
		}else {
			this.code = "9999";
		}
	}

	/**
	 * 广西公安互联网验证状态码
	 */
	private Integer state;

	public static String unLogin() {
		AjaxResult result = new AjaxResult();
		result.setCode("0000");
		result.setMsg("登录超时，请重新登录！");
		result.setSuccessful(false);
		return JSON.toJSONString(result);
	}

	public static AjaxResult error(String msg) {
		AjaxResult result = new AjaxResult();
		result.setCode("9999");
		result.setMsg(msg);
		//result.setSuccessful(false);
		return result;
	}

	public static AjaxResult success(String msg,Object data) {
		AjaxResult result = new AjaxResult();
		result.setCode("0");
		result.setMsg(msg);
		result.setSuccessful(true);
		result.setData(data);
		return result;
	}

	public static AjaxResult success() {
		AjaxResult result = new AjaxResult();
		result.setCode("0");
		result.setMsg("成功");
		result.setSuccessful(true);
		return result;
	}

	public static AjaxResult success(String msg) {
		AjaxResult result = new AjaxResult();
		result.setCode("0");
		result.setMsg(msg);
		result.setSuccessful(true);
		return result;
	}

	public static AjaxResult success(Object data) {
		AjaxResult result = new AjaxResult();
		result.setCode("0");
		result.setData(data);
		result.setMsg("成功");
		//result.setSuccessful(true);
		return result;
	}
}
