package com.abcxin.smart.validator.constraint;

import com.abcxin.smart.validator.annotation.Tel;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

/**
 * 固定电话验证器
 * Created by Dareen on 2018/3/24.
 */
public class TelValidator implements ConstraintValidator<Tel, String> {
    @Override
    public void initialize(Tel tel) {
        //默认值，初始化
    }

    /***
     * 验证方法
     * @param value 字段值
     * @param context
     * @return
     */
    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        //如果值为则返回false
        if (value == null) {
            return false;
        }
        String regex = "/^(0?(13[0-9]|15[012356789]|17[013678]|18[0-9]|14[57])[0-9]{8})|(400|800)([0-9\\\\\\\\-]{7,10})|(([0-9]{4}|[0-9]{3})(-| )?)?([0-9]{7,8})((-| |转)*([0-9]{1,4}))?$/";
        //验证固定电话是否正确
        if (value.matches(regex)) {
            return true;
        }
        return false;
    }
}