package com.abcxin.smart.validator.constraint;

import com.abcxin.smart.validator.annotation.Phone;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

/**
 * 手机验证器
 * Created by Dareen on 2018/3/24.
 */
public class PhoneValidator implements ConstraintValidator<Phone, String> {
    @Override
    public void initialize(Phone phone) {
        //默认值，初始化
    }

    /***
     * 验证方法
     * @param value 字段值
     * @param context
     * @return
     */
    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        //如果值为则返回false
        if (value == null) {
            return false;
        }
        String regex = "^([\\w-\\.]+)@((\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.)|(([\\w-]+\\.)+))([a-zA-Z]{2,4}|[0-9]{1,3})(\\]?)$";
        //验证手机是否正确
        if (value.matches(regex)) {
            return true;
        }
        return false;
    }
}