package com.abcxin.smart.validator.annotation;

import com.bcxin.ars.enums.MySqlDataFormatType;
import com.bcxin.ars.enums.SignType;
import org.springframework.beans.factory.annotation.Autowired;

import java.lang.annotation.*;

/**
 * @ClassName：com.abcxin.smart.validator.annotation
 * @author：zhongjianhui
 * @date：2018/9/7 9:32
 */
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface ModelAnnotation {
    /**
     * 字段名称
     */
    String getName() default "";

    /**
     * 是否为导出字段
     */
    boolean isExport() default false;

    /**
     * 数据库字段名称
     */
    String column() default "";

    /**
     * 需要转化的字段
     */
    boolean needTranslate() default false;

    /***
     * 码表是否多个
     * @return
     */
    boolean multipleCode() default  false;
    /**
     * 数据库中字典表的名称
     */
    String multipleCodeTableName() default "";
    /**
     * 数据库中字典表的名称
     */
    String dictName() default "";

    /**
     * 1对多
     */
    boolean oneToMore() default false;
    /**
     * 表名
     */
    String tableName() default "t1";
    /**
     * 默认选中
     */
    boolean defaultColumn() default false;

    /**
     * 特殊翻译类型
     */
    String specialTranslateType() default "";

    /**
     * 其他表
     */
    boolean anotherTable() default false;


    /***
     * 宽度
     */
    String width() default  "";
    /***
     * 居中方式
     * @return
     */
    String align() default  "center";

    /***
     * 字段格式化函数
     * @return
     */
    String formatter() default  "";

    /***
     * 是否在grid表字段
     * @return
     */
    boolean isGrid()  default false;

    /**
     * 符号
     * @return
     */
    SignType sign() default SignType.EQUAL;

    String DATE_FORMAT() default "";

    MySqlDataFormatType mySqlDataFormat() default MySqlDataFormatType.NULL;
}
