package com.abcxin.smart.validator.annotation;

import com.abcxin.smart.validator.enums.MethodType;
import com.abcxin.smart.validator.enums.ParamType;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * @ClassName：com.abcxin.smart.validator.annotation
 * @author：linqinglin
 * @date：2019/04/03 9:32
 */
@Target({ElementType.METHOD, ElementType.TYPE})
@Retention(RetentionPolicy.RUNTIME)
public @interface DataChangeAnnotation {

    ParamType getParamType() default ParamType.FIELD;


    /**
     * 实体类
     * @return
     */
    Class<?> getEntityClazz();

    /**
     * DAO类
     * @return
     */
    Class<?> getDaoClazz();

    /**
     * 参数类
     * @return
     */
    Class<?> getParamClazz();

    /**
     * 搜索方法名
     */
    String getSearchMethodName();

    /**
     * 搜索方法名
     */
    String getFieldName() default "id";
    String getTableNameField() default "";
}
