package com.bcxin.ars.dao;

import com.bcxin.ars.model.SecurityPerson;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.springframework.transaction.annotation.Transactional;

@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations = { "classpath:/ars-dao.xml" })
@Transactional
@TransactionConfiguration(transactionManager = "txManager", defaultRollback = true)
public class SecurityPersonDaoTest {
	
	@Autowired
	private UserDao userDao;

	@Autowired
	private SecurityPersonDao securityPersonDao;

	@Test
	public void testFindById() {
		SecurityPerson person = securityPersonDao.findById(697106684543238146l);
		securityPersonDao.updateSelective(person);
		Assert.assertNotNull(person);
	}
}
