package com.bcxin.ars.dao;

import java.util.Date;
import java.util.List;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.springframework.transaction.annotation.Transactional;

import com.bcxin.ars.model.Organization;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.model.User;

@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations = { "classpath:/ars-dao.xml" })
@Transactional
@TransactionConfiguration(transactionManager = "txManager", defaultRollback = true)
public class OrganizationDaoTest {
	
	@Autowired
	private UserDao userDao;

	@Autowired
	private OrganizationDao organizationDao;
	
	@Autowired
	private SecurityCompanyDao companyDao;
	
	@Test
	public void testSave() {
		User user = new UserDaoTest().buildUser();
		userDao.save(user);
		SecurityCompany company = new SecurityCompanyDaoTest().buildCompany();
		company.setUser(user);
		companyDao.save(company);
		Organization org1 = new Organization();
		org1.setActive(true);
		org1.setCreateTime(new Date());
		org1.setNativeCode(Long.parseLong("610328"));
		org1.setUpdateTime(new Date());
		org1.setName("赵四公司");
		org1.setUpdateBy("zhaosi");
		org1.setCompany(company);
		organizationDao.save(org1);
		Assert.assertNotNull(org1.getId());
		
		Organization org2 = new Organization();
		org2.setActive(true);
		org2.setCreateTime(new Date());
		org2.setNativeCode(Long.parseLong("610328"));
		org2.setUpdateTime(new Date());
		org2.setName("李四公司");
		org2.setUpdateBy("zhaosi");
		org2.setCompany(company);
		org2.setParent(org1);
		organizationDao.save(org2);
		Assert.assertNotNull(org2.getId());
		
		Organization org = organizationDao.findById(org1.getId());
		List<Organization> sList = org.getChildren();
		Assert.assertTrue(sList.size() > 0);
		
		Organization orgg = organizationDao.findById(org2.getId());
		Organization p = orgg.getParent();
		Assert.assertNotNull(p);
	}
	
}
