package com.bcxin.ars.dao;

import java.util.Date;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.springframework.transaction.annotation.Transactional;

import com.bcxin.ars.model.OrderPerson;

@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations = { "classpath:/ars-dao.xml" })
@Transactional
@TransactionConfiguration(transactionManager = "txManager", defaultRollback = true)
public class OrderPersonDaoTest {

	@Autowired
	private OrderPersonDao orderPersonDao;

	@Test
	public void testSave() {
		OrderPerson orderPerson = new OrderPerson();
		orderPerson.setActive(true);
		orderPerson.setCompanyname("1111342423");
		orderPerson.setCompanyid(123l);
		orderPerson.setCreateTime(new Date());
		orderPerson.setUpdateBy("system");
		orderPerson.setUpdateTime(new Date());
		orderPerson.setTrainorgid(43l);
		orderPerson.setTraintype("1");
		orderPerson.setPersonlevel("2");
		orderPerson.setPhone("123456879");
		orderPerson.setSigntime(new Date());
		orderPerson.setStudylong(3);
		orderPerson.setStudyprogress(2);
		orderPerson.setStudystate("1");
		orderPerson.setVideonum(2);
		orderPerson.setEndtime(new Date());
		orderPerson.setName("1233534drg");
		orderPerson.setOrderid(123l);
		orderPersonDao.save(orderPerson);
		OrderPerson dbPerson = orderPersonDao.findById(orderPerson.getId());
		Assert.assertNotNull(dbPerson);
	}
}
