package com.bcxin.ars.dao.supervision;

import com.abcxin.smart.validator.annotation.DataChangeAnnotation;
import com.abcxin.smart.validator.enums.ParamType;
import com.bcxin.ars.model.supervision.CompanyInspection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author yyx
 * @date 2020/06/15
 */
@Service
public class CompanyInspectionDaoAop {
    @Autowired
    private CompanyInspectionDao companyInspectionDao;

    @DataChangeAnnotation(getEntityClazz = CompanyInspection.class,
            getDaoClazz = CompanyComplaintDao.class,
            getParamClazz = Long.class,
            getSearchMethodName = "findByIdWithOutCache")
    public int delete(CompanyInspection companyInspection) {
        return companyInspectionDao.delete(companyInspection);
    }
    @DataChangeAnnotation(getEntityClazz = CompanyInspection.class,
            getDaoClazz = CompanyInspectionDao.class,
            getParamClazz = Long.class,
            getSearchMethodName = "findByIdWithOutCache")
    public void save(CompanyInspection companyInspection) {
        companyInspectionDao.save(companyInspection);
    }

    @DataChangeAnnotation(getEntityClazz = CompanyInspection.class,
            getDaoClazz = CompanyInspectionDao.class,
            getParamType = ParamType.ENTITY,
            getParamClazz = List.class,
            getSearchMethodName = "findByBatchIdWithOutCache")
    public void saveBatch(List<CompanyInspection> list) {
        companyInspectionDao.saveBatch(list);
    }
}
