package com.bcxin.ars.dao.subsidy;

import com.abcxin.smart.validator.annotation.DataChangeAnnotation;
import com.abcxin.smart.validator.enums.ParamType;
import com.bcxin.ars.model.subsidy.TrainSubsidyConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author linqinglin
 * @date 2020/06/03 0003 9:40
 */
@Service
public class TrainSubsidyConfigDaoAop {

    @Autowired
    private TrainSubsidyConfigDao trainSubsidyConfigDao;

    @DataChangeAnnotation(getEntityClazz = TrainSubsidyConfig.class,
            getDaoClazz = TrainSubsidyConfigDao.class,
            getParamClazz = Long.class,
            getSearchMethodName = "findByIdWithOutCache")
    public int delete(TrainSubsidyConfig trainSubsidyConfig) {
        return trainSubsidyConfigDao.delete(trainSubsidyConfig);
    }

    @DataChangeAnnotation(getEntityClazz = TrainSubsidyConfig.class,
            getDaoClazz = TrainSubsidyConfigDao.class,
            getParamClazz = Long.class,
            getSearchMethodName = "findByIdWithOutCache")
    public void save(TrainSubsidyConfig trainSubsidyConfig) {
        trainSubsidyConfigDao.save(trainSubsidyConfig);
    }

    @DataChangeAnnotation(getEntityClazz = TrainSubsidyConfig.class,
            getDaoClazz = TrainSubsidyConfigDao.class,
            getParamClazz = Long.class,
            getSearchMethodName = "findByIdWithOutCache")
    public void updateSelective(TrainSubsidyConfig trainSubsidyConfig) {
        trainSubsidyConfigDao.updateSelective(trainSubsidyConfig);
    }

    @DataChangeAnnotation(getEntityClazz = TrainSubsidyConfig.class,
            getDaoClazz = TrainSubsidyConfigDao.class,
            getParamType = ParamType.ENTITY,
            getParamClazz = List.class,
            getSearchMethodName = "findByBatchIdWithOutCache")
    public void saveBatch(List<TrainSubsidyConfig> list) {
        trainSubsidyConfigDao.saveBatch(list);
    }
}
