package com.bcxin.ars.dao.sb;

import com.abcxin.smart.validator.annotation.DataChangeAnnotation;
import com.bcxin.ars.model.sb.Shareholder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author linqinglin
 * @date 2020/05/11 0011 17:31
 */
@Service
public class ShareholderDaoAop {

    @Autowired
    private ShareholderDao shareholderDao;

    @DataChangeAnnotation(getEntityClazz = Shareholder.class,
            getDaoClazz = ShareholderDao.class,
            getParamClazz = Long.class,
            getSearchMethodName = "findByIdWithOutCache")
    public void updateCensorStatus(Shareholder shareholder) {
        shareholderDao.update(shareholder);
    }
}
