package com.bcxin.ars.dao.sb;

import com.abcxin.smart.validator.annotation.DataChangeAnnotation;
import com.abcxin.smart.validator.enums.ParamType;
import com.bcxin.ars.model.sb.Legalchange;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author linqinglin
 * @date 2020/06/18 0018 11:24
 */
@Service
public class LegalchangeDaoAop {

    @Autowired
    private LegalchangeDao legalchangeDao;

    @DataChangeAnnotation(getEntityClazz = Legalchange.class,
            getDaoClazz = LegalchangeDao.class,
            getParamClazz = Long.class,
            getSearchMethodName = "findByIdWithOutCache")
    public void delete(Legalchange legalchange) {
        legalchangeDao.delete(legalchange);
    }

    @DataChangeAnnotation(getEntityClazz = Legalchange.class,
            getDaoClazz = LegalchangeDao.class,
            getParamClazz = Long.class,
            getSearchMethodName = "findByIdWithOutCache")
    public void update(Legalchange legalchange) {
        legalchangeDao.update(legalchange);
    }

    @DataChangeAnnotation(getEntityClazz = Legalchange.class,
            getDaoClazz = LegalchangeDao.class,
            getParamType = ParamType.ENTITY,
            getParamClazz = List.class,
            getSearchMethodName = "findByBatchIdWithOutCache")
    public void updateBatch(List<Legalchange> list){
        legalchangeDao.updateBatch(list);
    }
}
