package com.bcxin.ars.dao;

import com.abcxin.smart.validator.annotation.DataChangeAnnotation;
import com.abcxin.smart.validator.enums.ParamType;
import com.bcxin.ars.model.SecurityGuard;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author linqinglin
 * @date 2020/07/06 0006 10:17
 */
@Service
public class SecurityGuardDaoAop {

    @Autowired
    private SecurityGuardDao securityGuardDao;


    @DataChangeAnnotation(getEntityClazz = SecurityGuard.class,
            getDaoClazz = SecurityGuardDao.class,
            getParamClazz = Long.class,
            getSearchMethodName = "findByIdWithOutCache")
    public void update(SecurityGuard securityGuard){
        securityGuardDao.update(securityGuard);
    }

    @DataChangeAnnotation(getEntityClazz = SecurityGuard.class,
            getDaoClazz = SecurityGuardDao.class,
            getParamType = ParamType.ENTITY,
            getParamClazz = List.class,
            getSearchMethodName = "findByBatchIdWithOutCache")
    public void updateFlagForOutToIn(List<SecurityGuard> list){
        securityGuardDao.updateFlagForOutToIn(list);
    }

    @DataChangeAnnotation(getEntityClazz = SecurityGuard.class,
            getDaoClazz = SecurityGuardDao.class,
            getParamType = ParamType.ENTITY,
            getParamClazz = List.class,
            getFieldName = "idNumber",
            getSearchMethodName = "findByIdNumsWithOutCache")
    public void batchUpdateByIdNums(List idNums,SecurityGuard securityGuard){
        securityGuardDao.batchUpdateByIdNums(idNums,securityGuard);
    }

    @DataChangeAnnotation(getEntityClazz = SecurityGuard.class,
            getDaoClazz = SecurityGuardDao.class,
            getParamType = ParamType.ENTITY,
            getParamClazz = List.class,
            getSearchMethodName = "findByBatchIdWithOutCache")
    public void saveBatch(List<SecurityGuard> list){
        securityGuardDao.saveBatch(list);
    }
}
