package com.bcxin.ars.dao;

import com.abcxin.smart.validator.annotation.DataChangeAnnotation;
import com.abcxin.smart.validator.enums.ParamType;
import com.bcxin.ars.model.SecurityCompany;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author linqinglin
 * @date 2020/06/18 0018 9:36
 */
@Service
public class SecurityCompanyDaoAop {

    @Autowired
    private SecurityCompanyDao securityCompanyDao;

    @DataChangeAnnotation(getEntityClazz = SecurityCompany.class,
            getDaoClazz = SecurityCompanyDao.class,
            getParamClazz = Long.class,
            getSearchMethodName = "findByIdWithOutCache")
    public void update(SecurityCompany securityCompany){
        securityCompanyDao.update(securityCompany);
    }

    @DataChangeAnnotation(getEntityClazz = SecurityCompany.class,
            getDaoClazz = SecurityCompanyDao.class,
            getParamClazz = Long.class,
            getSearchMethodName = "findByIdWithOutCache")
    public void delete(SecurityCompany securityCompany){
        securityCompanyDao.delete(securityCompany);
    }

    @DataChangeAnnotation(getEntityClazz = SecurityCompany.class,
            getDaoClazz = SecurityCompanyDao.class,
            getParamClazz = Long.class,
            getSearchMethodName = "findByIdWithOutCache")
    public void updateOperatorphone(SecurityCompany securityCompany){
        securityCompanyDao.updateOperatorphone(securityCompany);
    }

    @DataChangeAnnotation(getEntityClazz = SecurityCompany.class,
            getDaoClazz = SecurityCompanyDao.class,
            getParamType = ParamType.ENTITY,
            getParamClazz = List.class,
            getSearchMethodName = "findByBatchIdWithOutCache")
    public void saveBatch(List<SecurityCompany> list){
        securityCompanyDao.saveBatch(list);
    }

    public void revoke(SecurityCompany company) {
        securityCompanyDao.revoke(company);
    }
}
