package com.bcxin.ars.dao.task;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.UrgentPerson;
import com.bcxin.ars.model.task.TeamPerson;

import java.util.List;

/**
 * 保安人员与应急小队关系表
 * Created by Darren on 2017/3/28.
 */
public interface UrgentTeamPersonDAO {
    /***
     * 根据公司ID查询应急人员
     * @param companyId
     * @return
     */
    public List<UrgentPerson> queryUrgentPersonByCompnyId(Long companyId);
    
    /***
     * 根据保安员ID查询应急人员
     * @param personId
     * @return
     */
    public UrgentPerson queryUrgentPersonByPersonId(Long personId);
    /***
     * 删除应急小队
     * @param companyId 保安公司ID
     */
    public int delUrgentTeam(Long companyId);

    /**
     * 保存应急小队
     * @param teamPerson
     * @return
     */
    public int insert(TeamPerson teamPerson);

	List<TeamPerson> searchForDataSynchronization(DataSynchronizationSearchDto dto);
}
