package com.bcxin.ars.dao.task;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.model.task.ComTask;
import com.bcxin.ars.model.task.ComTaskPer;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 驻勤点与人员关联dao接口
 */
public interface ComTaskPerDao {

    /**
     * 根据驻勤点id与人员id删除
     * @param comTaskId
     * @param perId
     */
    void delete(@Param("comTaskId") Long comTaskId, @Param("perId") Long perId);

    /**
     * 插入
     * @param record
     */
    void insert(ComTaskPer record);

    /**
     * 根据驻勤点id查询
     * @param comTaskId
     * @return
     */
    List<ComTaskPer> findByTaskId(@Param("comTaskId") Long comTaskId);

    /**
     * 批量删除
     * @param removeList
     */
    void deleteBatch(@Param("list")List<ComTaskPer> removeList);

    /**
     * 批量保存
     * @param newPerList
     */
    void saveBatch(@Param("list")List<ComTaskPer> newPerList);

    void updateDeletePerson(@Param("personIds")Long[] personIds);


    /****
     * 保存
     * @param comTaskPer
     * @return
     */
    int save(ComTaskPer comTaskPer);

    /****
     * 修改
     * @param comTaskPer
     * @return
     */
    int update(ComTaskPer comTaskPer);

    /**
     * 外导内查询
     * @param searchDto
     * @return
     */
    List<ComTaskPer> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<ComTaskPer> findByBatchId(@Param("list")List<ComTaskPer> list);

    /**
     * 主键查询
     * @param comTaskPer
     * @return
     */
    ComTaskPer findById(ComTaskPer comTaskPer);

    /**
     * 根据驻勤点id删除人员关系表
     * @param comTaskId
     */
    void deleteByTaskId(@Param("comTaskId") Long comTaskId);

    void deleteByTaskIds(@Param("list") Long[] taskIdList);

    void deleteByTaskList(@Param("list") List<ComTask> taskList);
}