package com.bcxin.ars.dao.task;

import java.util.List;

import com.bcxin.ars.dto.AppNoticeSearchDto;
import com.bcxin.ars.model.task.AppNotice;

/**
 * APP消息通知
 * @author zhangye
 * @version 1.0.9
 */
public interface AppNoticeDao {

	/**
	 * 列表查询
	 * @param appNotice
	 * @return
	 */
	List<AppNotice> findAppNoticeList(AppNoticeSearchDto appNoticeSearchDto);
	
	 
	/**
	 * 统计APP消息列表
	 * @return
	 */
	Long countAppNotice(AppNoticeSearchDto appNoticeSearchDto);
	
	
	/**
	 * 设置消息通知为已读
	 * @param id
	 */
	void updateReadStatus(Long id);


	void save(AppNotice appNotice);
}
