package com.bcxin.ars.dao.sys;


import com.bcxin.ars.dto.LayTree;
import com.bcxin.ars.dto.Tree;
import com.bcxin.ars.dto.TreeView;
import com.bcxin.ars.dto.sys.SysareaSearchDTO;
import com.bcxin.ars.model.sys.Sysarea;

import java.util.List;

public interface SysareaDAO {
	
	Sysarea findById(Long id);
	
    List<TreeView> findTreeViewByParentId(Long parentid);

    List<TreeView> searchForTreeView(SysareaSearchDTO sysareaSearchDTO);
    
    List<TreeView> searchForCompany(SysareaSearchDTO sysareaSearchDTO);

    /**
     * 查询
     * @param sysareaSearchDTO
     * @return
     */
    List<Sysarea> search(SysareaSearchDTO sysareaSearchDTO);

    List<Sysarea> searchAll(SysareaSearchDTO sysareaSearchDTO);

    /**
     * 统计
     * @return
     */
    long count(SysareaSearchDTO dto);

    /**
     * 更新
     * @param sysarea
     */
    void update(Sysarea sysarea);

    List<Sysarea> findByParentId(Long parentid);
    
    Sysarea findByCode(String code);

	List<TreeView> findTreeViewByCode(String areacode);

	List<Sysarea> findAreaListByParentCode(SysareaSearchDTO sysareaSearchDTO);

    /**
     * 查询所有
     * @return
     */
    List<TreeView> selectAll();

    List<TreeView> selectByParentId(Long parentId);

    List<TreeView> searchSimpleTreeView(SysareaSearchDTO sysareaSearchDTO);

    List<Tree> searchForTree(SysareaSearchDTO dto);

    List<LayTree> searchForLayTree(SysareaSearchDTO searchDto);
}