package com.bcxin.ars.dao.sys;


import com.bcxin.ars.dto.sys.ImportConfigDto;
import com.bcxin.ars.model.sys.ImportConfig;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

public interface ImportConfigDao {
    /**
     * 根据id查询
     * @param id
     * @return
     */
    ImportConfig findById(Long id);

    ImportConfig findByIdWithOutCache(Long id);

    /**
     * 分页查询
     * @param importConfigDto
     * @param page
     */
    List<ImportConfig> search(ImportConfigDto importConfigDto, AjaxPageResponse<ImportConfig> page);
    /***
     * 保存
     * @param importConfig
     */
    void save(ImportConfig importConfig);

    /**
     * 根据业务类型查询相应的导入配置
     * @param businessType
     * @return
     */
    ImportConfig selectByBusinessType(String businessType);
}
