package com.bcxin.ars.dao.sys;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.model.sys.DataChange;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 *数据变更记录表Dao
 * @author linqinglin
 * @Date 2020-05-09 14:18:13
 */
public interface DataChangeDao {

   /****
     * 删除
     * @param dataChange
     * @return
     */
    int delete(DataChange dataChange);

    /****
     * 保存
     * @param dataChange
     * @return
     */
    int save(DataChange dataChange);

    /****
     * 新增
     * @param dataChange
     * @return
     */
    int insert(DataChange dataChange);

    /****
     * 选择性插入
     * @param dataChange
     * @return
     */
    int insertSelective(DataChange dataChange);

    /****
     * 主键查询
     * @param id
     * @return
     */
    DataChange findById(Long id);

    /****
     * 修改
     * @param dataChange
     * @return
     */
    int update(DataChange dataChange);

    /****
     * 选择修改
     * @param dataChange
     * @return
     */
    int updateSelective(DataChange dataChange);

    /**
     * 外导内查询
     * @param searchDto
     * @return
     */
    List<DataChange> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

    /**
     * 内导外查询
     * @param startDate
     * @return
     */
    List<DataChange> findDSOutList(String startDate);

    /**
     * 批量保存
     * @param list
     */
    void saveBatch(@Param("list") List<DataChange> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<DataChange> findByBatchId(@Param("list") List<DataChange> list);
}
