package com.bcxin.ars.dao.sb;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.YearReportInvestorSearchDto;
import com.bcxin.ars.model.sb.YearReportInvestor;

import java.util.List;

public interface YearReportInvestorDao {

	YearReportInvestor findById(long id);
	
	Long save(YearReportInvestor investor);
	
	void update(YearReportInvestor investor);
	
	List<YearReportInvestor> search(YearReportInvestorSearchDto dto);
	
	Long searchCount(YearReportInvestorSearchDto dto);

	void delete(YearReportInvestor investor);

	List<YearReportInvestor> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

	void saveForDS(YearReportInvestor investor);

	List<YearReportInvestor> findByUserId(Long userId);

	void deleteByYearReportId(Long yearReportId);

	List<YearReportInvestor> findByYearReportId(Long yearReportId);
}
