package com.bcxin.ars.dao.sb;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.YearReportInsuranceSearchDto;
import com.bcxin.ars.model.sb.YearReportInsurance;

import java.util.List;

public interface YearReportInsuranceDao {

	/**
	 * 查询
	 * @param yearReportInsuranceSearchDto
	 * @return
	 */
	List<YearReportInsurance> search(YearReportInsuranceSearchDto yearReportInsuranceSearchDto);

	/**
	 * 保存
	 * @param yearReportInsurance
	 * @return
	 */
	Long save(YearReportInsurance yearReportInsurance);

	/**
	 * 删除
	 * @param yearReportInsurance
	 * @return
	 */
	Long delete(YearReportInsurance yearReportInsurance);

	/**
	 * 根据ID查询
	 * @param id
	 * @return
	 */
	YearReportInsurance findById(Long id);
	/**
	 * 根据company_ID查询
	 * @param id
	 * @return
	 */
	List<YearReportInsurance> findByCompanyId(Long id);
	/**
	 * 统计
	 * @return
	 */
	long count(YearReportInsuranceSearchDto dto);

	/**
	 * 更新保安奖励信息
	 * @param yearReportInsurance
	 */
	void update(YearReportInsurance yearReportInsurance);

	void deleteBySid(long company_id);

	List<YearReportInsurance> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

	void updateForDS(YearReportInsurance yearReportInsurance);

	void saveForDS(YearReportInsurance yearReportInsurance);

	void deleteByYearReportId(Long yearReportId);

	List<YearReportInsurance> findByYearReportId(Long yearReportId);


}
