package com.bcxin.ars.dao.sb;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.model.sb.PersonAdapt;
import com.bcxin.ars.dto.page.PersonAdaptPageSearchDto;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 *保安员岗位适应性报名Dao
 * @author linqinglin
 * @Date 2020-04-10 10:39:21
 */
public interface PersonAdaptDao {

   /****
     * 删除
     * @param personAdapt
     * @return
     */
    int delete(PersonAdapt personAdapt);

    /****
     * 保存
     * @param personAdapt
     * @return
     */
    int save(PersonAdapt personAdapt);

    /****
     * 新增
     * @param personAdapt
     * @return
     */
    int insert(PersonAdapt personAdapt);

    /****
     * 选择性插入
     * @param personAdapt
     * @return
     */
    int insertSelective(PersonAdapt personAdapt);

    /****
     * 主键查询
     * @param id
     * @return
     */
    PersonAdapt findById(Long id);

    /****
     * 修改
     * @param personAdapt
     * @return
     */
    int update(PersonAdapt personAdapt);

    /****
     * 选择修改
     * @param personAdapt
     * @return
     */
    int updateSelective(PersonAdapt personAdapt);

    /**
     * 分页查询
     * @param searchDto
     * @param page
     * @return
     */
    List<PersonAdapt> searchForPage(PersonAdaptPageSearchDto searchDto, AjaxPageResponse<PersonAdapt> page);

    /**
     * 外导内查询
     * @param searchDto
     * @return
     */
    List<PersonAdapt> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

    /**
     * 内导外查询
     * @param startDate
     * @return
     */
    List<PersonAdapt> findDSOutList(String startDate);

    /**
     * 批量保存
     * @param list
     */
    void saveBatch(@Param("list") List<PersonAdapt> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<PersonAdapt> findByBatchId(@Param("list") List<PersonAdapt> list);

    List<PersonAdapt> findNoCensorStatus();
}
