package com.bcxin.ars.dao.sb;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.page.GradeSubsidyBatchPageSearchDto;
import com.bcxin.ars.model.sb.GradeSubsidyBatch;
import com.bcxin.ars.model.subsidy.SubsidyOffline;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 *等级证补贴批次Dao
 * @author linqinglin
 * @Date 2020-05-18 19:43:23
 */
public interface GradeSubsidyBatchDao {

   /****
     * 删除
     * @param gradeSubsidyBatch
     * @return
     */
    int delete(GradeSubsidyBatch gradeSubsidyBatch);

    /****
     * 保存
     * @param gradeSubsidyBatch
     * @return
     */
    int save(GradeSubsidyBatch gradeSubsidyBatch);

    /****
     * 新增
     * @param gradeSubsidyBatch
     * @return
     */
    int insert(GradeSubsidyBatch gradeSubsidyBatch);

    /****
     * 选择性插入
     * @param gradeSubsidyBatch
     * @return
     */
    int insertSelective(GradeSubsidyBatch gradeSubsidyBatch);

    /****
     * 主键查询
     * @param id
     * @return
     */
    GradeSubsidyBatch findById(Long id);

    GradeSubsidyBatch findByIdWithOutCache(Long id);

    /****
     * 修改
     * @param gradeSubsidyBatch
     * @return
     */
    int update(GradeSubsidyBatch gradeSubsidyBatch);


    int updateGrantState(@Param("id") String id);


 /****
     * 选择修改
     * @param gradeSubsidyBatch
     * @return
     */
    int updateSelective(GradeSubsidyBatch gradeSubsidyBatch);

    /**
     * 分页查询
     * @param searchDto
     * @param page
     * @return
     */
    List<GradeSubsidyBatch> searchForPage(GradeSubsidyBatchPageSearchDto searchDto, AjaxPageResponse<GradeSubsidyBatch> page);

    /**
     * 接口调用
     * @param searchDto
     * @param page
     * @return
     */
    List<GradeSubsidyBatch> searchForPageInterface(GradeSubsidyBatchPageSearchDto searchDto, AjaxPageResponse<GradeSubsidyBatch> page);


    List<Map>searchSubsidyMoney(GradeSubsidyBatchPageSearchDto searchDto);


    /**
     * 外导内查询
     * @param searchDto
     * @return
     */
    List<GradeSubsidyBatch> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

    /**
     * 内导外查询
     * @param startDate
     * @return
     */
    List<GradeSubsidyBatch> findDSOutList(String startDate);

    /**
     * 批量保存
     * @param list
     */
    void saveBatch(@Param("list") List<GradeSubsidyBatch> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<GradeSubsidyBatch> findByBatchId(@Param("list") List<GradeSubsidyBatch> list);

    List<GradeSubsidyBatch> findByBatchIdWithOutCache(@Param("list") List<GradeSubsidyBatch> list);

    List<GradeSubsidyBatch> findbyIds(@Param("idArr") Long[] batchIds);

    void updateApprovalStateBySubsidyOffline(SubsidyOffline subsidyOffline);

    List<GradeSubsidyBatch> findbyOfflineId(Long offlineId);

    /**
     * 根据批次名获取审批状态
     *
     * @param batchName 批次名称
     * @return 审批状态: 初审通过/审批不通过/初审中/线下审批中/审批通过
     */
    String findApprovalStatusByBatchName(String batchName);

    /**
     * 根据批次名获取数量
     *
     * @param batchName 批次名称
     * @return 0/1+
     */
    int findCountByBatchName(String batchName);
}
